/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.common;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.BitSet;
import juzu.UndeclaredIOException;

public final class PercentCodec {
    private static final byte[] codes;
    private static final int[] indices;
    private static final char[] ALPHABET;
    public static final PercentCodec PATH_SEGMENT;
    public static final PercentCodec QUERY_PARAM;
    private final BitSet allowed;

    private PercentCodec(BitSet allowed) {
        this.allowed = allowed;
    }

    public boolean accept(char c) {
        return c < this.allowed.length() && this.allowed.get(c);
    }

    public void encode(CharSequence s, Appendable appendable) throws IOException {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            this.encode(c, appendable);
        }
    }

    public String encode(CharSequence s) {
        try {
            StringBuilder sb = new StringBuilder(s.length());
            this.encode(s, (Appendable)sb);
            return sb.toString();
        }
        catch (IOException e) {
            throw new UndeclaredIOException(e);
        }
    }

    public void encode(char c, Appendable appendable) throws IOException {
        if (this.accept(c)) {
            appendable.append(c);
        } else if (c < indices.length - 1) {
            int from = indices[c];
            int to = indices[c + '\u0001'];
            while (from < to) {
                byte b = codes[from++];
                appendable.append('%');
                appendable.append(ALPHABET[(b & 0xF0) >> 4]);
                appendable.append(ALPHABET[b & 0xF]);
            }
        } else {
            throw new UnsupportedOperationException("Not handled yet");
        }
    }

    static {
        int c;
        Charset UTF8 = Charset.forName("UTF-8");
        CharsetEncoder encoder = UTF8.newEncoder();
        CharBuffer in = CharBuffer.allocate(1);
        ByteBuffer out = ByteBuffer.allocate(8);
        char size = '\u03e8';
        byte[] _codes = new byte[size * 2];
        int[] _indices = new int[size + 1];
        int ptr = 0;
        for (char c2 = '\u0000'; c2 < size; c2 = (char)(c2 + '\u0001')) {
            switch (Character.getType(c2)) {
                case 18: 
                case 19: {
                    break;
                }
                default: {
                    if (!encoder.canEncode(c2)) break;
                    in.rewind();
                    out.rewind();
                    in.put(0, c2);
                    encoder.reset();
                    encoder.encode(in, out, true);
                    encoder.flush(out);
                    int length = out.position();
                    System.arraycopy(out.array(), 0, _codes, ptr, length);
                    ptr += length;
                }
            }
            _indices[c2 + '\u0001'] = ptr;
        }
        codes = _codes;
        indices = _indices;
        BitSet allowed = new BitSet();
        for (c = 65; c <= 90; c = (int)((char)(c + 1))) {
            allowed.set(c);
        }
        for (c = 97; c <= 122; c = (int)((char)(c + 1))) {
            allowed.set(c);
        }
        for (c = 48; c <= 57; c = (int)((char)(c + 1))) {
            allowed.set(c);
        }
        allowed.set(95);
        allowed.set(46);
        allowed.set(45);
        allowed.set(126);
        allowed.set(33);
        allowed.set(36);
        allowed.set(38);
        allowed.set(39);
        allowed.set(40);
        allowed.set(41);
        allowed.set(42);
        allowed.set(43);
        allowed.set(44);
        allowed.set(59);
        allowed.set(61);
        allowed.set(58);
        allowed.set(64);
        PATH_SEGMENT = new PercentCodec(allowed);
        allowed = new BitSet(128);
        for (c = 65; c <= 90; c = (int)((char)(c + 1))) {
            allowed.set(c);
        }
        for (c = 97; c <= 122; c = (int)((char)(c + 1))) {
            allowed.set(c);
        }
        for (c = 48; c <= 57; c = (int)((char)(c + 1))) {
            allowed.set(c);
        }
        allowed.set(95);
        allowed.set(46);
        allowed.set(45);
        allowed.set(126);
        allowed.set(33);
        allowed.set(36);
        allowed.set(39);
        allowed.set(40);
        allowed.set(41);
        allowed.set(42);
        allowed.set(43);
        allowed.set(44);
        allowed.set(59);
        allowed.set(58);
        allowed.set(64);
        allowed.set(63);
        allowed.set(47);
        QUERY_PARAM = new PercentCodec(allowed);
        ALPHABET = "0123456789ABCDEF".toCharArray();
    }
}

