/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.plugin.module;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Map;
import juzu.impl.common.Logger;
import juzu.impl.compiler.CompilationException;
import juzu.impl.compiler.Compiler;
import juzu.impl.fs.Change;
import juzu.impl.fs.FileSystemScanner;
import juzu.impl.fs.Filter;
import juzu.impl.fs.spi.ReadFileSystem;
import juzu.impl.fs.spi.ram.RAMFileSystem;
import juzu.impl.fs.spi.url.URLFileSystem;
import juzu.processor.MainProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ModuleLifeCycle<C> {
    protected final Logger logger;

    protected ModuleLifeCycle(Logger logger) {
        this.logger = logger;
    }

    public abstract boolean refresh() throws Exception, CompilationException;

    public abstract ClassLoader getClassLoader();

    public abstract ReadFileSystem<C> getClasses();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Static<P>
    extends ModuleLifeCycle<P> {
        private final ClassLoader classLoader;
        private final ReadFileSystem<P> classes;

        public Static(Logger logger, ClassLoader classLoader, ReadFileSystem<P> classes) {
            super(logger);
            this.classLoader = classLoader;
            this.classes = classes;
        }

        @Override
        public boolean refresh() {
            return false;
        }

        @Override
        public ClassLoader getClassLoader() {
            return this.classLoader;
        }

        @Override
        public ReadFileSystem<P> getClasses() {
            return this.classes;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Dynamic<S>
    extends ModuleLifeCycle<String[]> {
        private final ReadFileSystem<S> source;
        private final ClassLoader baseClassLoader;
        private URLFileSystem classPath;
        private FileSystemScanner<S> scanner;
        private ClassLoader classLoader = null;
        private ReadFileSystem<String[]> classes;
        private boolean initialized;

        public Dynamic(Logger logger, ClassLoader baseClassLoader, ReadFileSystem<S> source) {
            super(logger);
            this.baseClassLoader = baseClassLoader;
            this.scanner = FileSystemScanner.createTimestamped(source);
            this.source = source;
            this.initialized = false;
        }

        @Override
        public boolean refresh() throws Exception, CompilationException {
            Map<String, Change> changes;
            if (!this.initialized) {
                this.classPath = new URLFileSystem().add(this.baseClassLoader, ClassLoader.getSystemClassLoader().getParent());
                this.scanner = FileSystemScanner.createHashing(this.source);
                this.initialized = true;
            }
            if ((changes = this.scanner.scan()).size() > 0) {
                this.logger.log("Detected changes : " + changes);
                this.logger.log("Building application");
                ReadFileSystem<S> sourcePath = this.scanner.getFileSystem();
                RAMFileSystem classOutput = new RAMFileSystem();
                sourcePath.copy(new Filter.Default(){

                    public boolean acceptFile(Object file, String name) throws IOException {
                        return !name.endsWith(".java");
                    }
                }, classOutput);
                Compiler compiler = Compiler.builder().sourcePath(sourcePath).sourceOutput(classOutput).classOutput(classOutput).addClassPath(this.classPath).build();
                compiler.addAnnotationProcessor(new MainProcessor());
                compiler.compile();
                this.classLoader = new URLClassLoader(new URL[]{classOutput.getURL()}, this.baseClassLoader);
                this.classes = classOutput;
                return true;
            }
            this.logger.log("No changes detected");
            return false;
        }

        @Override
        public ClassLoader getClassLoader() {
            return this.classLoader;
        }

        @Override
        public ReadFileSystem<String[]> getClasses() {
            return this.classes;
        }
    }
}

