/*
 * Decompiled with CFR 0.152.
 */
package juzu.template;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import juzu.PropertyMap;
import juzu.Response;
import juzu.UndeclaredIOException;
import juzu.impl.common.Path;
import juzu.impl.plugin.template.TemplatePlugin;
import juzu.impl.request.Request;
import juzu.io.AppendableStream;
import juzu.io.Stream;
import juzu.io.Streamable;
import juzu.request.MimeContext;
import juzu.request.RequestContext;
import juzu.template.TemplateExecutionException;
import juzu.template.TemplateRenderContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Template {
    private final Path path;
    private final TemplatePlugin applicationContext;

    public Template(TemplatePlugin applicationContext, String path) {
        this(applicationContext, Path.parse(path));
    }

    public Template(TemplatePlugin applicationContext, Path path) {
        this.applicationContext = applicationContext;
        this.path = path;
    }

    public final Path getPath() {
        return this.path;
    }

    public final String toString() {
        return this.getClass().getSimpleName() + "[path=" + this.path + "]";
    }

    public Response.Render render() throws TemplateExecutionException, UndeclaredIOException {
        return this.render(null, null);
    }

    public Response.Render render(Locale locale) throws TemplateExecutionException, UndeclaredIOException {
        return this.render(null, locale);
    }

    public Response.Render render(Map<String, ?> parameters) throws TemplateExecutionException, UndeclaredIOException {
        return this.render(parameters, null);
    }

    public Response.Render render(Map<String, ?> parameters, Locale locale) throws TemplateExecutionException, UndeclaredIOException {
        try {
            RequestContext context = Request.getCurrent().getContext();
            if (context instanceof MimeContext) {
                MimeContext mime = (MimeContext)context;
                PropertyMap properties = new PropertyMap();
                TemplateRenderContext streamable = this.applicationContext.render(this, properties, parameters, locale);
                StringBuilder sb = new StringBuilder();
                streamable.render(new AppendableStream(sb));
                Response.Render render = new Response.Render(properties, new Streamable.CharSequence(sb));
                mime.setResponse(render);
                return render;
            }
            throw new AssertionError((Object)"does not make sense");
        }
        catch (IOException e) {
            throw new UndeclaredIOException(e);
        }
    }

    public final Response.Content ok() {
        return this.ok(null, null);
    }

    public final Response.Content ok(Locale locale) {
        return this.ok(null, locale);
    }

    public final Response.Content ok(Map<String, ?> parameters) {
        return this.ok(parameters, null);
    }

    public final Response.Content<Stream.Char> ok(Map<String, ?> parameters, Locale locale) {
        StringBuilder sb = new StringBuilder();
        this.renderTo(new AppendableStream(sb), parameters, locale);
        return Response.ok(sb.toString());
    }

    public final Response.Content notFound() {
        return this.notFound(null, null);
    }

    public final Response.Content notFound(Locale locale) {
        return this.notFound(null, locale);
    }

    public final Response.Content notFound(Map<String, ?> parameters) {
        return this.notFound(parameters, null);
    }

    public final Response.Content<Stream.Char> notFound(Map<String, ?> parameters, Locale locale) {
        StringBuilder sb = new StringBuilder();
        this.renderTo(new AppendableStream(sb), parameters, locale);
        return Response.content(404, sb.toString());
    }

    public <A extends Appendable> A renderTo(A appendable) throws TemplateExecutionException, UndeclaredIOException {
        return this.renderTo(appendable, Collections.emptyMap(), null);
    }

    public <A extends Appendable> A renderTo(A appendable, Locale locale) throws TemplateExecutionException, UndeclaredIOException {
        return this.renderTo(appendable, Collections.emptyMap(), locale);
    }

    public <A extends Appendable> A renderTo(A appendable, Map<String, ?> parameters) throws TemplateExecutionException, UndeclaredIOException {
        return this.renderTo(appendable, parameters, null);
    }

    public <A extends Appendable> A renderTo(A appendable, Map<String, ?> parameters, Locale locale) throws TemplateExecutionException, UndeclaredIOException {
        if (appendable == null) {
            throw new NullPointerException("No null appendable can be provided");
        }
        this.renderTo(new AppendableStream(appendable), parameters, locale);
        return appendable;
    }

    public void renderTo(Stream.Char printer) throws TemplateExecutionException, UndeclaredIOException {
        this.renderTo(printer, (Map<String, ?>)Collections.emptyMap(), (Locale)null);
    }

    public void renderTo(Stream.Char printer, Locale locale) throws TemplateExecutionException, UndeclaredIOException {
        this.renderTo(printer, Collections.emptyMap(), locale);
    }

    public void renderTo(Stream.Char printer, Map<String, ?> parameters) throws TemplateExecutionException, UndeclaredIOException {
        this.renderTo(printer, parameters, (Locale)null);
    }

    public void renderTo(Stream.Char printer, Map<String, ?> parameters, Locale locale) throws TemplateExecutionException, UndeclaredIOException {
        if (printer == null) {
            throw new NullPointerException("No null printe provided");
        }
        try {
            TemplateRenderContext trc = this.applicationContext.render(this, null, parameters, locale);
            trc.render(printer);
        }
        catch (IOException e) {
            throw new UndeclaredIOException(e);
        }
    }

    public abstract Builder with();

    public Builder with(Locale locale) {
        Builder builder = this.with();
        builder.locale = locale;
        return builder;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Builder {
        private Map<String, Object> parameters;
        private Locale locale;

        public Builder set(String name, Object value) throws NullPointerException {
            if (name == null) {
                throw new NullPointerException("The parameter argument cannot be null");
            }
            if (value != null) {
                if (this.parameters == null) {
                    this.parameters = new HashMap<String, Object>();
                }
                this.parameters.put(name, value);
            } else if (this.parameters != null) {
                this.parameters.remove(name);
            }
            return this;
        }

        public Response.Render render() throws TemplateExecutionException, UndeclaredIOException {
            return Template.this.render(this.parameters, this.locale);
        }

        public final Response.Content ok() {
            return Template.this.ok(this.parameters, this.locale);
        }

        public final Response.Content notFound() {
            return Template.this.notFound(this.parameters, this.locale);
        }

        public <A extends Appendable> A renderTo(A appendable) throws TemplateExecutionException, UndeclaredIOException {
            return Template.this.renderTo(appendable, this.parameters, this.locale);
        }

        public void renderTo(Stream.Char printer) throws TemplateExecutionException, UndeclaredIOException {
            Template.this.renderTo(printer, this.parameters, this.locale);
        }
    }
}

