/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.bridge.spi.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import juzu.Response;
import juzu.impl.asset.AssetServer;
import juzu.impl.bridge.Bridge;
import juzu.impl.bridge.BridgeConfig;
import juzu.impl.bridge.spi.servlet.ServletLogger;
import juzu.impl.bridge.spi.servlet.ServletModuleContext;
import juzu.impl.bridge.spi.servlet.ServletWebBridge;
import juzu.impl.bridge.spi.web.Handler;
import juzu.impl.common.Formatting;
import juzu.impl.common.Logger;
import juzu.impl.common.SimpleMap;
import juzu.impl.common.Tools;
import juzu.impl.compiler.CompilationException;
import juzu.impl.plugin.module.Module;
import juzu.impl.resource.ResourceResolver;

public class ServletBridge
extends HttpServlet {
    Module module;
    Logger log;
    private String path;
    private BridgeConfig config;
    private Bridge bridge;
    private Handler handler;

    public void init() throws ServletException {
        BridgeConfig config;
        String path = null;
        ServletRegistration reg = this.getServletContext().getServletRegistration(this.getServletName());
        for (String mapping : reg.getMappings()) {
            if ("/".equals(mapping)) {
                path = "";
                break;
            }
            if ("/*".equals(mapping)) {
                throw new UnsupportedOperationException("Implement me");
            }
            if (mapping.endsWith("/*")) {
                path = mapping.substring(0, mapping.length() - 2);
                continue;
            }
            throw new UnsupportedOperationException("Should not be possible");
        }
        if (path == null) {
            throw new ServletException("Juzu servlet should be mounted on an url pattern");
        }
        final ServletConfig servletConfig = this.getServletConfig();
        ServletLogger log = new ServletLogger(servletConfig);
        try {
            config = new BridgeConfig((Map<String, String>)new SimpleMap<String, String>(){

                @Override
                protected Iterator<String> keys() {
                    return BridgeConfig.NAMES.iterator();
                }

                @Override
                public String get(Object key) {
                    if ("juzu.app_name".equals(key)) {
                        return ServletBridge.this.getApplicationName(servletConfig);
                    }
                    if ("juzu.inject".equals(key)) {
                        String inject = servletConfig.getInitParameter((String)key);
                        if (inject == null) {
                            inject = servletConfig.getServletContext().getInitParameter((String)key);
                        }
                        return inject;
                    }
                    if (BridgeConfig.NAMES.contains(key)) {
                        return servletConfig.getInitParameter((String)key);
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            throw ServletBridge.wrap(e);
        }
        if (config.name == null) {
            throw new ServletException("No application configured");
        }
        this.log = log;
        this.config = config;
        this.handler = null;
        this.path = path;
    }

    static ServletException wrap(Throwable e) {
        return e instanceof ServletException ? (ServletException)e : new ServletException("Could not find an application to start", e);
    }

    protected String getApplicationName(ServletConfig config) {
        return config.getInitParameter("juzu.app_name");
    }

    private void refresh() throws Exception {
        boolean stale;
        AssetServer server;
        if (this.module == null) {
            this.module = (Module)this.getServletContext().getAttribute("juzu.module");
            if (this.module == null) {
                try {
                    ServletModuleContext moduleContext = new ServletModuleContext(this.getServletContext(), this.log);
                    this.module = new Module(moduleContext);
                    this.getServletContext().setAttribute("juzu.module", (Object)this.module);
                }
                catch (Exception e) {
                    throw ServletBridge.wrap(e);
                }
            }
            this.module.lease();
        }
        if ((server = (AssetServer)this.getServletContext().getAttribute("asset.server")) == null) {
            server = new AssetServer();
            this.getServletContext().setAttribute("asset.server", (Object)server);
        }
        if (this.bridge == null) {
            this.bridge = new Bridge(this.log, this.module, this.config, this.module.context.getResourcePath(), server, new ResourceResolver(){

                public URL resolve(String uri) {
                    try {
                        return ServletBridge.this.getServletConfig().getServletContext().getResource(uri);
                    }
                    catch (MalformedURLException e) {
                        return null;
                    }
                }
            });
        }
        if ((stale = this.bridge.refresh()) && this.handler != null) {
            Tools.safeClose(this.handler);
            this.handler = null;
        }
        if (this.handler == null) {
            this.handler = new Handler(this.bridge);
        }
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        URL url;
        ServletWebBridge bridge = new ServletWebBridge(req, resp, this.path, this.log);
        if (bridge.getRequestPath().length() > 1 && !bridge.getRequestPath().startsWith("/WEB-INF/") && (url = this.getServletContext().getResource(bridge.getRequestPath())) != null) {
            RequestDispatcher dispatcher = this.getServletContext().getNamedDispatcher("default");
            dispatcher.include((ServletRequest)bridge.getRequest(), (ServletResponse)bridge.getResponse());
            return;
        }
        try {
            this.refresh();
        }
        catch (CompilationException e) {
            StringWriter writer = new StringWriter();
            PrintWriter printer = new PrintWriter(writer);
            Formatting.renderErrors(printer, e.getErrors());
            bridge.send(Response.error(writer.getBuffer().toString()), true);
            return;
        }
        catch (Exception e) {
            throw ServletBridge.wrap(e);
        }
        try {
            this.handler.handle(bridge);
        }
        catch (Throwable throwable) {
            throw ServletBridge.wrap(throwable);
        }
    }

    public void destroy() {
        if (this.module == null || this.module.release()) {
            // empty if block
        }
        if (this.handler != null) {
            Tools.safeClose(this.handler);
            this.handler = null;
        }
    }
}

