/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.plugin.controller;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import juzu.Response;
import juzu.UndeclaredIOException;
import juzu.impl.bridge.spi.ActionBridge;
import juzu.impl.bridge.spi.EventBridge;
import juzu.impl.bridge.spi.RenderBridge;
import juzu.impl.bridge.spi.RequestBridge;
import juzu.impl.bridge.spi.ResourceBridge;
import juzu.impl.common.MethodHandle;
import juzu.impl.inject.ScopeController;
import juzu.impl.inject.spi.InjectionContext;
import juzu.impl.metadata.Descriptor;
import juzu.impl.plugin.PluginContext;
import juzu.impl.plugin.application.ApplicationPlugin;
import juzu.impl.plugin.controller.ControllerResolver;
import juzu.impl.plugin.controller.descriptor.ControllersDescriptor;
import juzu.impl.request.ContextualParameter;
import juzu.impl.request.Method;
import juzu.impl.request.Parameter;
import juzu.impl.request.Request;
import juzu.impl.request.RequestFilter;
import juzu.request.ActionContext;
import juzu.request.ApplicationContext;
import juzu.request.ClientContext;
import juzu.request.HttpContext;
import juzu.request.Phase;
import juzu.request.RequestContext;
import juzu.request.ResourceContext;
import juzu.request.SecurityContext;
import juzu.request.UserContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControllerPlugin
extends ApplicationPlugin
implements RequestFilter {
    private ControllersDescriptor descriptor;
    public ArrayList<RequestFilter> filters;
    @Inject
    private InjectionContext injectionContext;

    public ControllerPlugin() {
        super("controller");
    }

    public ControllersDescriptor getDescriptor() {
        return this.descriptor;
    }

    public ControllerResolver<Method> getResolver() {
        return this.descriptor != null ? this.descriptor.getResolver() : null;
    }

    @Override
    public Descriptor init(PluginContext context) throws Exception {
        this.descriptor = new ControllersDescriptor(context.getClassLoader(), context.getConfig());
        return this.descriptor;
    }

    public InjectionContext getInjectionContext() {
        return this.injectionContext;
    }

    public List<RequestFilter> getFilters() {
        try {
            return this.getLifecycles(this.injectionContext);
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("handle me cracefully", e);
        }
    }

    private <B, I> ArrayList<RequestFilter> getLifecycles(InjectionContext<B, I> manager) throws Exception {
        if (this.filters == null) {
            ArrayList<RequestFilter> filters = new ArrayList<RequestFilter>();
            for (B lifeCycleBean : manager.resolveBeans(RequestFilter.class)) {
                I lifeCycleInstance = manager.create(lifeCycleBean);
                RequestFilter filter = (RequestFilter)manager.get(lifeCycleBean, lifeCycleInstance);
                filters.add(filter);
            }
            this.filters = filters;
        }
        return this.filters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(RequestBridge bridge) {
        block16: {
            Phase phase;
            if (bridge instanceof RenderBridge) {
                phase = Phase.VIEW;
            } else if (bridge instanceof ActionBridge) {
                phase = Phase.ACTION;
            } else if (bridge instanceof EventBridge) {
                phase = Phase.EVENT;
            } else if (bridge instanceof ResourceBridge) {
                phase = Phase.RESOURCE;
            } else {
                throw new AssertionError();
            }
            Map<String, String[]> parameters = bridge.getParameters();
            MethodHandle handle = bridge.getTarget();
            Method method = this.descriptor.getMethodByHandle(handle);
            if (method == null) {
                StringBuilder sb = new StringBuilder("handle me gracefully : no method could be resolved for phase=").append(phase).append(" handle=").append(handle).append(" parameters={");
                int index = 0;
                for (Map.Entry<String, String[]> entry : parameters.entrySet()) {
                    if (index++ > 0) {
                        sb.append(',');
                    }
                    sb.append(entry.getKey()).append('=').append(Arrays.asList((Object[])entry.getValue()));
                }
                sb.append("}");
                throw new UnsupportedOperationException(sb.toString());
            }
            Request request = new Request(this, method, parameters, bridge);
            ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
            try {
                ClassLoader classLoader = this.injectionContext.getClassLoader();
                Thread.currentThread().setContextClassLoader(classLoader);
                ScopeController.begin(request);
                bridge.begin(request);
                request.invoke();
                Response response = request.getResponse();
                if (response == null) break block16;
                try {
                    bridge.setResponse(response);
                }
                catch (IOException e) {
                    throw new UndeclaredIOException(e);
                }
            }
            finally {
                bridge.end();
                ScopeController.end();
                Thread.currentThread().setContextClassLoader(oldCL);
            }
        }
    }

    @Override
    public void invoke(Request request) {
        RequestContext context = request.getContext();
        Method method = context.getMethod();
        for (Parameter parameter : method.getParameters()) {
            if (!(parameter instanceof ContextualParameter)) continue;
            ContextualParameter contextualParameter = (ContextualParameter)parameter;
            this.tryInject(request, contextualParameter, RequestContext.class, context);
            this.tryInject(request, contextualParameter, HttpContext.class, context.getHttpContext());
            this.tryInject(request, contextualParameter, SecurityContext.class, context.getSecurityContext());
            this.tryInject(request, contextualParameter, ApplicationContext.class, context.getApplicationContext());
            this.tryInject(request, contextualParameter, UserContext.class, context.getUserContext());
            if (context instanceof ResourceContext) {
                ResourceContext resourceContext = (ResourceContext)context;
                this.tryInject(request, contextualParameter, ClientContext.class, resourceContext.getClientContext());
                continue;
            }
            if (!(context instanceof ActionContext)) continue;
            ActionContext actionContext = (ActionContext)context;
            this.tryInject(request, contextualParameter, ClientContext.class, actionContext.getClientContext());
        }
        request.invoke();
    }

    private <T> void tryInject(Request request, ContextualParameter parameter, Class<T> type, T instance) {
        if (instance != null && type.isAssignableFrom(parameter.getType())) {
            request.setArgument(parameter, instance);
        }
    }
}

