/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.plugin.application;

import java.io.Closeable;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import juzu.Scope;
import juzu.impl.asset.AssetManager;
import juzu.impl.asset.AssetServer;
import juzu.impl.common.Filter;
import juzu.impl.common.JSON;
import juzu.impl.common.Logger;
import juzu.impl.common.Name;
import juzu.impl.common.Tools;
import juzu.impl.fs.spi.ReadFileSystem;
import juzu.impl.inject.BeanDescriptor;
import juzu.impl.inject.spi.BeanLifeCycle;
import juzu.impl.inject.spi.InjectionContext;
import juzu.impl.inject.spi.Injector;
import juzu.impl.inject.spi.InjectorProvider;
import juzu.impl.inject.spi.spring.SpringInjector;
import juzu.impl.metadata.Descriptor;
import juzu.impl.plugin.Plugin;
import juzu.impl.plugin.PluginContext;
import juzu.impl.plugin.application.Application;
import juzu.impl.plugin.application.ApplicationPlugin;
import juzu.impl.plugin.application.descriptor.ApplicationDescriptor;
import juzu.impl.plugin.asset.AssetPlugin;
import juzu.impl.plugin.module.ModuleLifeCycle;
import juzu.impl.resource.ResourceResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationLifeCycle<P, R>
implements Closeable {
    private final Name name;
    private final InjectorProvider injectorProvider;
    private final Logger log;
    private final ReadFileSystem<R> resources;
    private final ResourceResolver resourceResolver;
    private final AssetServer assetServer;
    private final ModuleLifeCycle<?> moduleLifeCycle;
    private ApplicationDescriptor descriptor;
    private AssetManager stylesheetManager;
    private AssetManager scriptManager;
    private InjectionContext<?, ?> injectionContext;
    private BeanLifeCycle<Application> application;
    private ClassLoader classLoader;
    private Map<String, ApplicationPlugin> plugins;
    private Map<String, Descriptor> pluginDescriptors;

    public ApplicationLifeCycle(Logger log, ModuleLifeCycle<?> moduleLifeCycle, InjectorProvider injectorProvider, Name name, ReadFileSystem<R> resources, AssetServer assetServer, ResourceResolver resourceResolver) {
        this.log = log;
        this.moduleLifeCycle = moduleLifeCycle;
        this.injectorProvider = injectorProvider;
        this.name = name;
        this.resources = resources;
        this.assetServer = assetServer;
        this.resourceResolver = resourceResolver;
    }

    public Name getName() {
        return this.name;
    }

    public Application getApplication() {
        return this.application != null ? this.application.peek() : null;
    }

    public AssetManager getScriptManager() {
        return this.scriptManager;
    }

    public AssetManager getStylesheetManager() {
        return this.stylesheetManager;
    }

    public ApplicationDescriptor getDescriptor() {
        return this.descriptor;
    }

    public <P extends Plugin> P getPlugin(Class<P> pluginType) {
        try {
            BeanLifeCycle<P> pluginLifeCycle = this.injectionContext.get(pluginType);
            return (P)(pluginLifeCycle != null ? (Plugin)pluginLifeCycle.get() : null);
        }
        catch (InvocationTargetException e) {
            throw new UnsupportedOperationException("Handle me gracefully", e);
        }
    }

    public boolean refresh() throws Exception {
        if (this.application != null && this.classLoader != this.moduleLifeCycle.getClassLoader()) {
            this.stop();
        }
        if (this.application == null) {
            this.log.log("Building application");
            this.start();
            return true;
        }
        return false;
    }

    protected final void start() throws Exception {
        R springName;
        ReadFileSystem<?> classes = this.moduleLifeCycle.getClasses();
        Name fqn = this.name.append("Application");
        Class<?> clazz = this.moduleLifeCycle.getClassLoader().loadClass(fqn.toString());
        ApplicationDescriptor descriptor = ApplicationDescriptor.create(clazz);
        HashMap<String, ApplicationPlugin> plugins = new HashMap<String, ApplicationPlugin>();
        for (ApplicationPlugin plugin : ServiceLoader.load(ApplicationPlugin.class)) {
            plugins.put(plugin.getName(), plugin);
        }
        HashSet<String> names = new HashSet<String>(descriptor.getConfig().names());
        HashMap<ApplicationPlugin, JSON> configs = new HashMap<ApplicationPlugin, JSON>();
        for (ApplicationPlugin plugin : plugins.values()) {
            String name = plugin.getName();
            if (names.remove(name)) {
                configs.put(plugin, descriptor.getConfig().getJSON(plugin.getName()));
                continue;
            }
            configs.put(plugin, null);
        }
        if (names.size() > 0) {
            throw new UnsupportedOperationException("Handle me gracefully : missing plugins " + names);
        }
        final ResourceResolver applicationResolver = new ResourceResolver(){

            public URL resolve(String uri) {
                return ApplicationLifeCycle.this.moduleLifeCycle.getClassLoader().getResource(uri.substring(1));
            }
        };
        HashMap<String, Descriptor> pluginDescriptors = new HashMap<String, Descriptor>();
        for (final Map.Entry entry : configs.entrySet()) {
            ApplicationPlugin plugin = (ApplicationPlugin)entry.getKey();
            PluginContext pluginContext = new PluginContext(){

                public JSON getConfig() {
                    return (JSON)entry.getValue();
                }

                public ClassLoader getClassLoader() {
                    return ApplicationLifeCycle.this.moduleLifeCycle.getClassLoader();
                }

                public ResourceResolver getServerResolver() {
                    return ApplicationLifeCycle.this.resourceResolver;
                }

                public ResourceResolver getApplicationResolver() {
                    return applicationResolver;
                }
            };
            plugin.setApplication(descriptor);
            Descriptor pluginDescriptor = plugin.init(pluginContext);
            if (pluginDescriptor == null) continue;
            pluginDescriptors.put(plugin.getName(), pluginDescriptor);
        }
        Iterator i = plugins.keySet().iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            if (pluginDescriptors.containsKey(name)) continue;
            i.remove();
        }
        InjectorProvider provider = this.injectorProvider;
        Injector injector = (Injector)provider.get();
        injector.addFileSystem(classes);
        injector.setClassLoader(this.moduleLifeCycle.getClassLoader());
        if (injector instanceof SpringInjector && (springName = this.resources.getPath("spring.xml")) != null) {
            URL configurationURL = this.resources.getURL(springName);
            ((SpringInjector)injector).setConfigurationURL(configurationURL);
        }
        this.log.log("Starting " + descriptor.getName());
        InjectionContext injectionContext = ApplicationLifeCycle.doStart(descriptor, injector, plugins.values(), pluginDescriptors.values());
        AssetPlugin assetPlugin = injectionContext.get(AssetPlugin.class).get();
        BeanLifeCycle<Application> application = injectionContext.get(Application.class);
        if (this.assetServer != null) {
            this.assetServer.register(this);
        }
        this.injectionContext = injectionContext;
        this.scriptManager = assetPlugin.getScriptManager();
        this.stylesheetManager = assetPlugin.getStylesheetManager();
        this.descriptor = descriptor;
        this.application = application;
        this.classLoader = this.moduleLifeCycle.getClassLoader();
        this.plugins = plugins;
        this.pluginDescriptors = pluginDescriptors;
        try {
            application.get();
        }
        catch (InvocationTargetException e) {
            throw new UnsupportedOperationException("handle me gracefully", e);
        }
    }

    private static <B, I> InjectionContext<B, I> doStart(final ApplicationDescriptor descriptor, Injector injector, Collection<ApplicationPlugin> plugins, Collection<Descriptor> pluginDescriptors) {
        InjectionContext<?, ?> injectionContext;
        injector.bindBean(ApplicationDescriptor.class, null, descriptor);
        injector.declareBean(Application.class, null, null, null);
        for (Scope scope : Scope.values()) {
            injector.addScope(scope);
        }
        for (ApplicationPlugin plugin : plugins) {
            Class<?> aClass = plugin.getClass();
            ApplicationPlugin o = plugin;
            injector.bindBean(aClass, null, o);
        }
        for (Descriptor pluginDescriptor : pluginDescriptors) {
            for (BeanDescriptor bean : pluginDescriptor.getBeans()) {
                bean.bind(injector);
            }
        }
        Filter filter = new Filter<Class<?>>(){
            HashSet<String> blackList = new HashSet();

            @Override
            public boolean accept(Class<?> elt) {
                if (elt.getName().startsWith("juzu.")) {
                    return false;
                }
                if (elt.getPackage().getName().startsWith(descriptor.getPackageName())) {
                    return true;
                }
                String currentPkg = elt.getPackage().getName();
                while (currentPkg != null) {
                    if (this.blackList.contains(currentPkg)) {
                        return false;
                    }
                    try {
                        Class<?> packageClass = descriptor.getApplicationLoader().loadClass(currentPkg + ".package-info");
                        juzu.Application ann = packageClass.getAnnotation(juzu.Application.class);
                        if (ann != null) {
                            this.blackList.add(currentPkg);
                            return false;
                        }
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                    currentPkg = Tools.parentPackageOf(currentPkg);
                }
                return true;
            }
        };
        try {
            injectionContext = injector.create(filter);
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("handle me gracefully", e);
        }
        return injectionContext;
    }

    void stop() {
        if (this.assetServer != null) {
            this.assetServer.unregister(this);
        }
        Tools.safeClose(this.application);
        Tools.safeClose(this.injectionContext);
        this.application = null;
        this.injectionContext = null;
        this.stylesheetManager = null;
        this.scriptManager = null;
        this.descriptor = null;
        this.classLoader = null;
        this.plugins = null;
        this.pluginDescriptors = null;
    }

    @Override
    public void close() {
        this.stop();
    }
}

