/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.plugin.template;

import java.lang.reflect.Constructor;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import juzu.impl.common.Path;
import juzu.impl.metadata.Descriptor;
import juzu.impl.plugin.PluginContext;
import juzu.impl.plugin.application.Application;
import juzu.impl.plugin.application.ApplicationPlugin;
import juzu.impl.plugin.template.metadata.TemplateDescriptor;
import juzu.impl.plugin.template.metadata.TemplatesDescriptor;
import juzu.impl.template.spi.TemplateStub;

public class TemplatePlugin
extends ApplicationPlugin {
    private TemplatesDescriptor descriptor;
    private final ConcurrentHashMap<Path, TemplateStub> stubs = new ConcurrentHashMap();
    @Inject
    Application application;

    public TemplatePlugin() {
        super("template");
    }

    public TemplatesDescriptor getDescriptor() {
        return this.descriptor;
    }

    public Descriptor init(PluginContext context) throws Exception {
        this.descriptor = new TemplatesDescriptor(context.getClassLoader(), context.getConfig());
        return this.descriptor;
    }

    public TemplateStub resolveTemplateStub(String path) {
        return this.resolveTemplateStub(Path.parse(path));
    }

    public TemplateStub resolveTemplateStub(Path path) {
        TemplateStub stub = this.stubs.get(path);
        if (stub == null) {
            TemplateDescriptor desc = this.descriptor.getTemplate(path.getCanonical());
            try {
                Constructor<? extends TemplateStub> ctor = desc.getStubType().getConstructor(String.class);
                stub = ctor.newInstance(desc.getType().getName());
            }
            catch (Exception e) {
                throw new UnsupportedOperationException("Handle me gracefully", e);
            }
            TemplateStub phantom = this.stubs.putIfAbsent(path, stub);
            if (phantom != null) {
                stub = phantom;
            } else {
                stub.init(this.application.getClassLoader());
            }
        }
        return stub;
    }
}

