/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.bridge.spi.web;

import java.io.IOException;
import java.util.LinkedList;
import java.util.Map;
import juzu.PropertyType;
import juzu.Response;
import juzu.asset.AssetLocation;
import juzu.impl.asset.Asset;
import juzu.impl.asset.AssetManager;
import juzu.impl.bridge.spi.web.AsyncStream;
import juzu.impl.bridge.spi.web.HttpStream;
import juzu.impl.common.Tools;
import juzu.io.Chunk;
import juzu.io.Stream;
import org.w3c.dom.Element;

public abstract class WebStream
implements AsyncStream {
    private static final int BUFFERING = 0;
    private static final int STREAMING = 1;
    private static final int CLOSED = 2;
    private static final int FAILED = 3;
    private final HttpStream stream;
    private int status = 0;
    private final AssetManager stylesheetManager;
    private final AssetManager scriptManager;
    private final Page page;

    public WebStream(HttpStream stream, AssetManager stylesheetManager, AssetManager scriptManager) {
        this.stream = stream;
        this.stylesheetManager = stylesheetManager;
        this.scriptManager = scriptManager;
        this.page = new Page();
    }

    public void provide(Chunk chunk) {
        if (this.status == 0) {
            if (chunk instanceof Chunk.Property) {
                Chunk.Property property = (Chunk.Property)chunk;
                if (property.type == PropertyType.TITLE) {
                    this.page.title = (String)property.value;
                } else if (property.type == PropertyType.META_TAG) {
                    this.page.metaTags.add((Map.Entry)property.value);
                } else if (property.type == PropertyType.STYLESHEET) {
                    this.page.stylesheets.add((String)property.value);
                } else if (property.type == PropertyType.SCRIPT) {
                    this.page.scripts.add((String)property.value);
                } else if (property.type == PropertyType.HEADER_TAG) {
                    this.page.headerTags.add((Element)property.value);
                } else {
                    this.stream.provide(property);
                }
            } else if (chunk instanceof Chunk.Data) {
                try {
                    if (this.page.stylesheets.size() > 0 && this.stylesheetManager != null) {
                        Iterable<Asset> stylesheetAssets = this.stylesheetManager.resolveAssets(this.page.stylesheets);
                        Tools.addAll(this.page.stylesheetAssets, stylesheetAssets);
                    }
                    if (this.page.scripts.size() > 0 && this.scriptManager != null) {
                        Iterable<Asset> scriptAssets = this.scriptManager.resolveAssets(this.page.scripts);
                        Tools.addAll(this.page.scriptAssets, scriptAssets);
                    }
                    this.status = 1;
                    this.page.sendHeader(this.stream);
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                    this.status = 3;
                    this.stream.setStatusCode(500);
                    this.page.clear();
                    this.page.sendHeader(this.stream);
                    Response.error((Throwable)e).result().asStatus((boolean)true).streamable.send(new Stream(){

                        public void provide(Chunk chunk) {
                            WebStream.this.stream.provide(chunk);
                        }

                        public void close(Thread.UncaughtExceptionHandler errorHandler) {
                        }
                    });
                    this.page.sendFooter(this.stream);
                    return;
                }
            }
        }
        if (this.status == 1) {
            this.stream.provide(chunk);
        }
    }

    public abstract String renderAssetURL(AssetLocation var1, String var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(Thread.UncaughtExceptionHandler errorHandler) {
        if (this.status != 2) {
            try {
                if (this.status == 0) {
                    this.provide(Chunk.create(""));
                }
                if (this.status == 1) {
                    this.page.sendFooter(this.stream);
                }
                Object var3_2 = null;
                this.status = 2;
                this.stream.close(errorHandler);
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.status = 2;
                this.stream.close(errorHandler);
                throw throwable;
            }
        }
    }

    public void end() {
        this.stream.end();
    }

    private class Page {
        private String title = null;
        private final LinkedList<Map.Entry<String, String>> metaTags = new LinkedList();
        private final LinkedList<String> stylesheets = new LinkedList();
        private final LinkedList<String> scripts = new LinkedList();
        private final LinkedList<Element> headerTags = new LinkedList();
        private final LinkedList<Asset> scriptAssets = new LinkedList();
        private final LinkedList<Asset> stylesheetAssets = new LinkedList();

        private Page() {
        }

        void clear() {
            this.title = null;
            this.metaTags.clear();
            this.stylesheetAssets.clear();
            this.scriptAssets.clear();
            this.headerTags.clear();
        }

        void sendHeader(Stream stream) {
            stream.provide(Chunk.create("<!DOCTYPE html>\n<html>\n<head>\n"));
            if (this.title != null) {
                stream.provide(Chunk.create("<title>\n"));
                stream.provide(Chunk.create(this.title));
                stream.provide(Chunk.create("</title>\n"));
            }
            for (Map.Entry entry : this.metaTags) {
                stream.provide(Chunk.create("<meta name=\""));
                stream.provide(Chunk.create((CharSequence)entry.getKey()));
                stream.provide(Chunk.create("\" content=\""));
                stream.provide(Chunk.create((CharSequence)entry.getValue()));
                stream.provide(Chunk.create("\">\n"));
            }
            for (Asset asset : this.stylesheetAssets) {
                String path = asset.getURI();
                int pos = path.lastIndexOf(46);
                String ext = pos == -1 ? "css" : path.substring(pos + 1);
                String url = WebStream.this.renderAssetURL(asset.getLocation(), asset.getURI());
                stream.provide(Chunk.create("<link rel=\"stylesheet\" type=\"text/"));
                stream.provide(Chunk.create(ext));
                stream.provide(Chunk.create("\" href=\""));
                stream.provide(Chunk.create(url));
                stream.provide(Chunk.create("\"></link>\n"));
            }
            for (Asset asset : this.scriptAssets) {
                String url = WebStream.this.renderAssetURL(asset.getLocation(), asset.getURI());
                stream.provide(Chunk.create("<script type=\"text/javascript\" src=\""));
                stream.provide(Chunk.create(url));
                stream.provide(Chunk.create("\"></script>\n"));
            }
            for (Element element : this.headerTags) {
                try {
                    StringBuilder buffer = new StringBuilder();
                    Tools.encodeHtml(element, buffer);
                    stream.provide(Chunk.create(buffer));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            stream.provide(Chunk.create("</head>\n<body>\n"));
        }

        void sendFooter(Stream stream) {
            stream.provide(Chunk.create("</body>\n</html>\n"));
        }
    }
}

