/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.request;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import juzu.Response;
import juzu.Scope;
import juzu.impl.bridge.Parameters;
import juzu.impl.bridge.spi.ActionBridge;
import juzu.impl.bridge.spi.DispatchBridge;
import juzu.impl.bridge.spi.EventBridge;
import juzu.impl.bridge.spi.RenderBridge;
import juzu.impl.bridge.spi.RequestBridge;
import juzu.impl.bridge.spi.ResourceBridge;
import juzu.impl.bridge.spi.ScopedContext;
import juzu.impl.common.Tools;
import juzu.impl.inject.ScopeController;
import juzu.impl.inject.Scoped;
import juzu.impl.inject.ScopingContext;
import juzu.impl.inject.spi.BeanLifeCycle;
import juzu.impl.inject.spi.InjectionContext;
import juzu.impl.plugin.controller.ControllerPlugin;
import juzu.impl.plugin.controller.descriptor.ControllersDescriptor;
import juzu.impl.request.ContextLifeCycle;
import juzu.impl.request.ContextualParameter;
import juzu.impl.request.ControlParameter;
import juzu.impl.request.ExecutionFilter;
import juzu.impl.request.Method;
import juzu.impl.request.RequestFilter;
import juzu.request.ActionContext;
import juzu.request.ApplicationContext;
import juzu.request.ClientContext;
import juzu.request.Dispatch;
import juzu.request.EventContext;
import juzu.request.HttpContext;
import juzu.request.Phase;
import juzu.request.RenderContext;
import juzu.request.RequestContext;
import juzu.request.RequestLifeCycle;
import juzu.request.RequestParameter;
import juzu.request.ResourceContext;
import juzu.request.Result;
import juzu.request.SecurityContext;
import juzu.request.UserContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Request
implements ScopingContext {
    private static final Object[] EMPTY = new Object[0];
    static final ThreadLocal<ContextLifeCycle> current = new ThreadLocal();
    final LinkedHashSet<ContextLifeCycle> contextLifeCycles = new LinkedHashSet();
    BeanLifeCycle controllerLifeCycle = null;
    final RequestBridge bridge;
    private final ControllerPlugin controllerPlugin;
    private final Map<String, RequestParameter> parameters;
    private final Map<ControlParameter, Object> arguments;
    private final Method<?> method;
    private Result result;
    private int index = 0;
    private ContextLifeCycle contextLifeCycle;

    public static Request getCurrent() {
        ContextLifeCycle context = current.get();
        return context != null ? context.getRequest() : null;
    }

    public Request(ControllerPlugin controllerPlugin, Method method, Map<String, RequestParameter> parameters, RequestBridge bridge) {
        HashMap<ControlParameter, Object> arguments = new HashMap<ControlParameter, Object>(bridge.getArguments());
        this.bridge = bridge;
        this.parameters = parameters;
        this.arguments = arguments;
        this.controllerPlugin = controllerPlugin;
        this.method = method;
    }

    public ClientContext getClientContext() {
        RequestBridge bridge = this.getBridge();
        if (bridge instanceof ActionBridge) {
            return ((ActionBridge)bridge).getClientContext();
        }
        if (bridge instanceof ResourceBridge) {
            return ((ResourceBridge)bridge).getClientContext();
        }
        return null;
    }

    public HttpContext getHttpContext() {
        return this.getBridge().getHttpContext();
    }

    public SecurityContext getSecurityContext() {
        return this.getBridge().getSecurityContext();
    }

    public UserContext getUserContext() {
        return this.getBridge().getUserContext();
    }

    public ApplicationContext getApplicationContext() {
        return this.getBridge().getApplicationContext();
    }

    public Method<?> getMethod() {
        return this.method;
    }

    public Phase getPhase() {
        return this.method.getPhase();
    }

    public ScopeController getScopeController() {
        return this.controllerPlugin.getInjectionContext().getScopeController();
    }

    public RequestBridge getBridge() {
        return this.bridge;
    }

    public Result getResult() {
        return this.result;
    }

    public void setResult(Result result) {
        this.result = result;
    }

    public void setResponse(Response response) {
        this.result = response == null ? null : response.result();
    }

    public Map<String, RequestParameter> getParameters() {
        return this.parameters;
    }

    public Map<ControlParameter, Object> getArguments() {
        return this.arguments;
    }

    public void setArguments(Map<ControlParameter, Object> arguments) {
        this.arguments.clear();
        this.arguments.putAll(arguments);
    }

    public void setArgument(ControlParameter parameter, Object value) {
        this.arguments.put(parameter, value);
    }

    @Override
    public final Scoped getContextualValue(Scope scope, Object key) {
        ScopedContext context = this.bridge.getScopedContext(scope, false);
        return context != null ? context.get(key) : null;
    }

    @Override
    public final void setContextualValue(Scope scope, Object key, Scoped value) {
        if (value == null) {
            ScopedContext context = this.bridge.getScopedContext(scope, false);
            if (context != null) {
                context.set(key, null);
            }
        } else {
            this.bridge.getScopedContext(scope, true).set(key, value);
        }
    }

    @Override
    public boolean isActive(Scope scope) {
        switch (scope) {
            case IDENTITY: {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke() {
        block11: {
            boolean set = current.get() == null;
            try {
                if (set) {
                    this.contextLifeCycle = new ContextLifeCycle(this);
                    current.set(this.contextLifeCycle);
                    this.getScopeController().begin(this);
                }
                ArrayList<RequestFilter> filters = Tools.list(this.controllerPlugin.getInjectionContext().resolveInstances(RequestFilter.class));
                if (this.index >= 0 && this.index < filters.size()) {
                    RequestFilter plugin = (RequestFilter)filters.get(this.index);
                    try {
                        ++this.index;
                        plugin.invoke(this);
                        break block11;
                    }
                    finally {
                        --this.index;
                    }
                }
                if (this.index == filters.size()) {
                    Response response = this.dispatch(this, this.controllerPlugin.getInjectionContext());
                    if (response != null) {
                        this.setResponse(response);
                    }
                    break block11;
                }
                throw new AssertionError();
            }
            finally {
                if (set) {
                    this.contextLifeCycle.endContextual();
                    current.set(null);
                }
            }
        }
    }

    public Executor getExecutor() {
        final Iterable<ExecutionFilter> filters = this.controllerPlugin.getInjectionContext().resolveInstances(ExecutionFilter.class);
        return new Executor(){

            public void execute(Runnable command) {
                for (ExecutionFilter filter : filters) {
                    command = filter.onCommand(command);
                }
                Request.this.execute(command);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(final Runnable runnable) throws RejectedExecutionException {
        final ContextLifeCycle contextLifeCycle = new ContextLifeCycle(this);
        this.contextLifeCycles.add(contextLifeCycle);
        Runnable wrapper = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    Request.this.getScopeController().begin(Request.this);
                    current.set(contextLifeCycle);
                    runnable.run();
                }
                finally {
                    current.set(null);
                    contextLifeCycle.endContextual();
                }
            }
        };
        boolean executed = false;
        try {
            this.bridge.execute(wrapper);
            executed = true;
        }
        finally {
            if (!executed) {
                contextLifeCycle.endContextual();
            }
        }
    }

    public ContextLifeCycle suspend() {
        ContextLifeCycle lifeCycle = current.get();
        if (lifeCycle == null) {
            throw new IllegalStateException("No current active request");
        }
        if (lifeCycle.getRequest() != this) {
            throw new IllegalStateException("Current request is not active");
        }
        current.set(null);
        return lifeCycle;
    }

    private <T> void tryInject(Request request, ContextualParameter parameter, Class<T> type, T instance) {
        if (instance != null && type.isAssignableFrom(parameter.getType())) {
            request.setArgument(parameter, instance);
        }
    }

    private <B, I> Response dispatch(Request request, InjectionContext<B, I> manager) {
        RequestContext context = this.bridge instanceof RenderBridge ? new RenderContext(this, this.method, (RenderBridge)this.bridge) : (this.bridge instanceof ActionBridge ? new ActionContext(this, this.method, (ActionBridge)this.bridge) : (this.bridge instanceof EventBridge ? new EventContext(this, this.method, (EventBridge)this.bridge) : new ResourceContext(this, this.method, (ResourceBridge)this.bridge)));
        for (ControlParameter parameter : this.method.getParameters()) {
            if (!(parameter instanceof ContextualParameter)) continue;
            ContextualParameter contextualParameter = (ContextualParameter)parameter;
            this.tryInject(request, contextualParameter, RequestContext.class, context);
            this.tryInject(request, contextualParameter, HttpContext.class, request.getHttpContext());
            this.tryInject(request, contextualParameter, SecurityContext.class, request.getSecurityContext());
            this.tryInject(request, contextualParameter, ApplicationContext.class, request.getApplicationContext());
            this.tryInject(request, contextualParameter, UserContext.class, request.getUserContext());
            if (context instanceof ResourceContext) {
                ResourceContext resourceContext = (ResourceContext)context;
                this.tryInject(request, contextualParameter, ClientContext.class, resourceContext.getClientContext());
                continue;
            }
            if (!(context instanceof ActionContext)) continue;
            ActionContext actionContext = (ActionContext)context;
            this.tryInject(request, contextualParameter, ClientContext.class, actionContext.getClientContext());
        }
        Object[] args = new Object[this.method.getParameters().size()];
        for (int i = 0; i < args.length; ++i) {
            ControlParameter parameter = this.method.getParameters().get(i);
            args[i] = this.arguments.get(parameter);
        }
        Class<?> type = context.getMethod().getType();
        this.controllerLifeCycle = manager.get(type);
        if (this.controllerLifeCycle != null) {
            Object controller;
            try {
                controller = this.controllerLifeCycle.get();
            }
            catch (InvocationTargetException e) {
                context.setResponse(Response.error(Tools.safeCause(e)));
                controller = null;
            }
            if (controller != null) {
                if (controller instanceof RequestLifeCycle) {
                    try {
                        ((RequestLifeCycle)controller).beginRequest(context);
                    }
                    catch (Exception e) {
                        context.setResponse(new Response.Error(e));
                    }
                }
                if (context.getResponse() == null) {
                    try {
                        Object ret = context.getMethod().getMethod().invoke(controller, args);
                        if (ret instanceof Response) {
                            context.setResponse((Response)ret);
                        }
                    }
                    catch (InvocationTargetException e) {
                        context.setResponse(Response.error(e.getCause()));
                    }
                    catch (IllegalAccessException e) {
                        throw new UnsupportedOperationException("hanle me gracefully", e);
                    }
                    if (controller instanceof RequestLifeCycle) {
                        try {
                            ((RequestLifeCycle)controller).endRequest(context);
                        }
                        catch (Exception e) {
                            context.setResponse(Response.error(e));
                        }
                    }
                }
            }
        }
        return context.getResponse();
    }

    private Dispatch createDispatch(Method<?> method, DispatchBridge spi) {
        Dispatch dispatch;
        ControllersDescriptor desc = this.controllerPlugin.getDescriptor();
        if (method.getPhase() == Phase.ACTION) {
            dispatch = new Phase.Action.Dispatch(spi);
        } else if (method.getPhase() == Phase.VIEW) {
            dispatch = new Phase.View.Dispatch(spi);
            dispatch.escapeXML(desc.getEscapeXML());
        } else if (method.getPhase() == Phase.RESOURCE) {
            dispatch = new Phase.Resource.Dispatch(spi);
            dispatch.escapeXML(desc.getEscapeXML());
        } else {
            throw new AssertionError();
        }
        dispatch.escapeXML(desc.getEscapeXML());
        return dispatch;
    }

    public Dispatch createDispatch(Method<?> method, Object[] args) {
        Parameters parameters = new Parameters();
        method.setArgs(args, parameters);
        DispatchBridge spi = this.getBridge().createDispatch((Phase)method.getPhase(), method.getHandle(), parameters);
        return this.createDispatch(method, spi);
    }

    public Dispatch createDispatch(Method<?> method) {
        DispatchBridge spi = this.getBridge().createDispatch((Phase)method.getPhase(), method.getHandle(), new Parameters());
        return this.createDispatch(method, spi);
    }

    private static Dispatch safeCreateDispatch(Method<?> method, Object[] args) {
        ContextLifeCycle context = current.get();
        if (context != null) {
            return context.getRequest().createDispatch(method, args);
        }
        return null;
    }

    public static Phase.Action.Dispatch createActionDispatch(Method<Phase.Action> method) {
        return (Phase.Action.Dispatch)Request.safeCreateDispatch(method, EMPTY);
    }

    public static Phase.Action.Dispatch createActionDispatch(Method<Phase.Action> method, Object arg) {
        return (Phase.Action.Dispatch)Request.safeCreateDispatch(method, new Object[]{arg});
    }

    public static Phase.Action.Dispatch createActionDispatch(Method<Phase.Action> method, Object[] args) {
        return (Phase.Action.Dispatch)Request.safeCreateDispatch(method, args);
    }

    public static Phase.View.Dispatch createViewDispatch(Method<Phase.View> method) {
        return (Phase.View.Dispatch)Request.safeCreateDispatch(method, EMPTY);
    }

    public static Phase.View.Dispatch createViewDispatch(Method<Phase.View> method, Object arg) {
        return (Phase.View.Dispatch)Request.safeCreateDispatch(method, new Object[]{arg});
    }

    public static Phase.View.Dispatch createViewDispatch(Method<Phase.View> method, Object[] args) {
        return (Phase.View.Dispatch)Request.safeCreateDispatch(method, args);
    }

    public static Phase.Resource.Dispatch createResourceDispatch(Method<Phase.Resource> method) {
        return (Phase.Resource.Dispatch)Request.safeCreateDispatch(method, EMPTY);
    }

    public static Phase.Resource.Dispatch createResourceDispatch(Method<Phase.Resource> method, Object arg) {
        return (Phase.Resource.Dispatch)Request.safeCreateDispatch(method, new Object[]{arg});
    }

    public static Phase.Resource.Dispatch createResourceDispatch(Method<Phase.Resource> method, Object[] args) {
        return (Phase.Resource.Dispatch)Request.safeCreateDispatch(method, args);
    }
}

