/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.plugin.module.metamodel;

import java.io.IOException;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.StandardLocation;
import juzu.impl.common.JSON;
import juzu.impl.common.Tools;
import juzu.impl.compiler.ProcessingContext;
import juzu.impl.compiler.ProcessingException;
import juzu.impl.metamodel.MetaModel;
import juzu.impl.plugin.application.metamodel.ApplicationMetaModel;
import juzu.impl.plugin.module.metamodel.ModuleMetaModelPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleMetaModel
extends MetaModel<ModuleMetaModelPlugin, ModuleMetaModel> {
    private static final ThreadLocal<ModuleMetaModel> current = new ThreadLocal();
    private Set<Class<? extends Annotation>> supportedAnnotations;

    @Override
    public void init(ProcessingContext env) {
        this.supportedAnnotations = new HashSet<Class<Annotation>>(this.context.getSupportedAnnotations());
    }

    @Override
    public Set<Class<? extends Annotation>> getSupportedAnnotations() {
        return this.supportedAnnotations;
    }

    @Override
    public JSON toJSON() {
        JSON json = new JSON();
        for (ModuleMetaModelPlugin plugin : this.context.getPlugins()) {
            JSON pluginJSON = plugin.toJSON(this);
            json.set(plugin.getName(), pluginJSON);
        }
        return json;
    }

    @Override
    public final void postActivate(ProcessingContext env) {
        current.set(this);
        this.context.postActivate(env);
    }

    @Override
    public final void postProcessAnnotations() throws ProcessingException {
        this.context.postProcessAnnotations();
    }

    @Override
    public final void processEvents() {
        this.context.processEvents();
    }

    @Override
    public final void postProcessEvents() {
        this.context.postProcessEvents();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void prePassivate() {
        ProcessingContext env = this.processingContext;
        this.emitConfig(env);
        try {
            this.context.prePassivate();
        }
        finally {
            current.set(null);
        }
    }

    private void emitConfig(ProcessingContext env) {
        env.log("Emitting module config");
        JSON descriptor = null;
        for (ModuleMetaModelPlugin plugin : this.context.getPlugins()) {
            JSON pluginDesc = plugin.getDescriptor(this);
            if (pluginDesc == null) continue;
            if (descriptor == null) {
                descriptor = new JSON();
            }
            descriptor.set(plugin.getName(), pluginDesc);
        }
        if (descriptor != null) {
            Writer writer = null;
            try {
                FileObject fo = env.createResource((JavaFileManager.Location)StandardLocation.CLASS_OUTPUT, "juzu", "config.json", new Element[0]);
                writer = fo.openWriter();
                descriptor.toString(writer, 2);
            }
            catch (IOException e) {
                try {
                    throw ApplicationMetaModel.CANNOT_WRITE_CONFIG.failure(e);
                }
                catch (Throwable throwable) {
                    Tools.safeClose(writer);
                    throw throwable;
                }
            }
            Tools.safeClose(writer);
        }
    }
}

