/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.router.regex;

import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import juzu.impl.common.CharStream;
import juzu.impl.router.regex.Kind;
import juzu.impl.router.regex.SyntaxException;

class Lexer {
    private static final Pattern QUANTIFIER_PATTERN = Pattern.compile("^\\{([0-9]+)(?:(,)([0-9]+)?)?\\}$");
    private static final Pattern OCTAL_PATTERN = Pattern.compile("^[0-7]|[0-7][0-7]|[0-3][0-7][0-7]$");
    private final CharStream stream;
    private int ccDepth;
    private Kind next;
    private String token;
    private Kind previous;

    Lexer(CharStream stream) {
        this.stream = stream;
        this.ccDepth = 0;
        this.next = null;
        this.previous = null;
        this.token = null;
    }

    Lexer(CharSequence seq) {
        this(new CharStream(seq));
    }

    int getIndex() {
        return this.stream.getIndex();
    }

    void reset() {
        this.stream.reset();
        this.ccDepth = 0;
        this.next = null;
        this.previous = null;
        this.token = null;
    }

    String getToken() {
        return this.token;
    }

    boolean isDone() {
        return !this.stream.hasNext();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean hasNext() throws SyntaxException {
        if (this.next == null && this.stream.hasNext()) {
            Kind kind;
            char c = this.stream.next();
            switch (c) {
                case '^': {
                    kind = Kind.BEGIN;
                    this.token = "^";
                    break;
                }
                case '$': {
                    kind = Kind.END;
                    this.token = "$";
                    break;
                }
                case '.': {
                    kind = Kind.ANY;
                    this.token = ".";
                    break;
                }
                case '-': {
                    if (this.ccDepth > 0) {
                        if (this.stream.hasNext(']')) {
                            kind = Kind.LITERAL;
                            this.token = "-";
                            break;
                        }
                        if (this.previous == Kind.CC_OPEN) {
                            kind = Kind.LITERAL;
                            this.token = "-";
                            break;
                        }
                        if (this.previous == Kind.HYPHEN) {
                            kind = Kind.LITERAL;
                            this.token = "-";
                            break;
                        }
                        kind = Kind.HYPHEN;
                        this.token = "-";
                        break;
                    }
                    kind = Kind.LITERAL;
                    this.token = "-";
                    break;
                }
                case '|': {
                    kind = Kind.OR;
                    this.token = "|";
                    break;
                }
                case '[': {
                    kind = Kind.CC_OPEN;
                    this.token = this.stream.next('^') ? "[^" : "[";
                    ++this.ccDepth;
                    break;
                }
                case ']': {
                    if (this.ccDepth > 0) {
                        if (this.previous == Kind.CC_OPEN) {
                            kind = Kind.LITERAL;
                            this.token = "]";
                            break;
                        }
                        kind = Kind.CC_CLOSE;
                        this.token = "]";
                        --this.ccDepth;
                        break;
                    }
                    kind = Kind.LITERAL;
                    this.token = "]";
                    break;
                }
                case '&': {
                    if (this.stream.next('&')) {
                        kind = Kind.CC_AND;
                        this.token = "&&";
                        break;
                    }
                    kind = Kind.LITERAL;
                    this.token = "&";
                    break;
                }
                case '\\': {
                    if (!this.stream.hasNext()) throw new SyntaxException();
                    c = this.stream.peek().charValue();
                    if (c == '0') {
                        StringBuilder sb = new StringBuilder().append(this.stream.next());
                        Character matched = null;
                        while (this.stream.hasNext()) {
                            sb.append(this.stream.peek());
                            Matcher matcher = OCTAL_PATTERN.matcher(sb);
                            if (!matcher.matches()) break;
                            matched = Character.valueOf((char)Integer.parseInt(sb.toString(), 8));
                            this.stream.next();
                        }
                        if (matched == null) throw new SyntaxException();
                        kind = Kind.LITERAL;
                        this.token = Character.toString(matched.charValue());
                        break;
                    }
                    if (c == 'x') {
                        this.stream.next();
                        if (!this.stream.has(1)) throw new SyntaxException();
                        String s = "" + this.stream.next() + this.stream.next();
                        try {
                            kind = Kind.LITERAL;
                            this.token = Character.toString((char)Integer.parseInt(s, 16));
                            break;
                        }
                        catch (NumberFormatException e) {
                            throw new SyntaxException();
                        }
                    }
                    if (c == 'u') {
                        this.stream.next();
                        if (!this.stream.has(3)) throw new SyntaxException();
                        String s = "" + this.stream.next() + this.stream.next() + this.stream.next() + this.stream.next();
                        try {
                            kind = Kind.LITERAL;
                            this.token = Character.toString((char)Integer.parseInt(s, 16));
                            break;
                        }
                        catch (NumberFormatException e) {
                            throw new SyntaxException();
                        }
                    }
                    if (Character.isLetterOrDigit(c)) {
                        throw new SyntaxException();
                    }
                    this.stream.next();
                    kind = Kind.LITERAL;
                    this.token = "" + c;
                    break;
                }
                case '(': {
                    if (this.ccDepth == 0) {
                        StringBuilder sb = new StringBuilder("(");
                        if (this.stream.hasNext('?') && !this.stream.has(1, ')')) {
                            this.stream.next();
                            sb.append('?');
                            if (this.stream.hasNext(':') || this.stream.hasNext('=') || this.stream.hasNext('!')) {
                                sb.append(this.stream.next());
                            } else {
                                if (!this.stream.next('<')) throw new SyntaxException();
                                sb.append('<');
                                if (!this.stream.hasNext('=')) {
                                    if (!this.stream.hasNext('!')) throw new SyntaxException();
                                }
                                sb.append(this.stream.next());
                            }
                        }
                        kind = Kind.GROUP_OPEN;
                        this.token = sb.toString();
                        break;
                    }
                    kind = Kind.LITERAL;
                    this.token = "(";
                    break;
                }
                case '?': {
                    if (this.previous == Kind.GROUP_OPEN) {
                        kind = Kind.LITERAL;
                        this.token = "?";
                        break;
                    }
                    if (this.previous == Kind.QUANTIFIER) {
                        kind = Kind.QUANTIFIER_MODE;
                        this.token = "?";
                        break;
                    }
                    kind = Kind.QUANTIFIER;
                    this.token = "?";
                    break;
                }
                case '+': {
                    if (this.previous == Kind.QUANTIFIER) {
                        kind = Kind.QUANTIFIER_MODE;
                        this.token = "+";
                        break;
                    }
                    kind = Kind.QUANTIFIER;
                    this.token = "+";
                    break;
                }
                case '*': {
                    kind = Kind.QUANTIFIER;
                    this.token = "*";
                    break;
                }
                case '{': {
                    if (this.ccDepth == 0) {
                        StringBuilder sb = new StringBuilder("{");
                        while (this.stream.hasNext()) {
                            c = this.stream.next();
                            sb.append(c);
                            if (c != '}') continue;
                        }
                        if (!QUANTIFIER_PATTERN.matcher(sb).matches()) throw new SyntaxException();
                        kind = Kind.QUANTIFIER;
                        this.token = sb.toString();
                        break;
                    }
                    kind = Kind.LITERAL;
                    this.token = "{";
                    break;
                }
                case ')': {
                    if (this.ccDepth == 0) {
                        kind = Kind.GROUP_CLOSE;
                        this.token = ")";
                        break;
                    }
                    kind = Kind.LITERAL;
                    this.token = ")";
                    break;
                }
                default: {
                    kind = Kind.LITERAL;
                    this.token = "" + c;
                }
            }
            this.next = kind;
        }
        if (this.next == null) return false;
        return true;
    }

    boolean next(Kind expected) throws SyntaxException {
        if (this.hasNext() && expected == this.next) {
            this.previous = this.next();
            this.next = null;
            return true;
        }
        return false;
    }

    Kind next() throws SyntaxException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.previous = this.next;
        this.next = null;
        return this.previous;
    }
}

