/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.compiler;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import juzu.Response;
import juzu.impl.common.Formatting;
import juzu.impl.compiler.CompilationError;
import juzu.request.Result;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompilationException
extends Exception {
    private List<CompilationError> errors;

    public CompilationException(List<CompilationError> errors) {
        this.errors = errors;
    }

    public List<CompilationError> getErrors() {
        return this.errors;
    }

    @Override
    public String toString() {
        return "CompilationException[" + this.errors + "]";
    }

    public Result.Error result() {
        try {
            StringWriter writer = new StringWriter();
            PrintWriter printer = new PrintWriter(writer);
            Formatting.renderErrors(printer, this.errors);
            return Response.error(writer.getBuffer().toString()).result();
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }
}

