/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.compiler;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import juzu.impl.common.FileKey;
import juzu.impl.compiler.file.CompositeFileManager;
import juzu.impl.compiler.file.FileManager;
import juzu.impl.compiler.file.JavaFileObjectImpl;
import juzu.impl.compiler.file.SimpleFileManager;
import juzu.impl.fs.spi.ReadFileSystem;
import juzu.impl.fs.spi.ReadWriteFileSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class VirtualFileManager
extends ForwardingJavaFileManager<JavaFileManager>
implements StandardJavaFileManager {
    final SimpleFileManager<?> sourcePath;
    final SimpleFileManager<?> classOutput;
    final CompositeFileManager classPath;
    final SimpleFileManager<?> sourceOutput;

    public VirtualFileManager(JavaFileManager fileManager, ReadFileSystem<?> sourcePath, Collection<ReadFileSystem<?>> classPath, ReadWriteFileSystem<?> sourceOutput, ReadWriteFileSystem<?> classOutput) {
        super(fileManager);
        this.sourcePath = this.safeWrap(StandardLocation.SOURCE_PATH, sourcePath);
        this.classPath = new CompositeFileManager(StandardLocation.CLASS_PATH, classPath);
        this.classOutput = this.safeWrap(StandardLocation.CLASS_OUTPUT, classOutput);
        this.sourceOutput = this.safeWrap(StandardLocation.SOURCE_OUTPUT, sourceOutput);
    }

    private <P> SimpleFileManager<P> safeWrap(StandardLocation location, ReadFileSystem<P> fs) {
        return fs != null ? new SimpleFileManager<P>(location, fs) : null;
    }

    private FileManager getFiles(JavaFileManager.Location location) {
        if (location instanceof StandardLocation) {
            switch ((StandardLocation)location) {
                case SOURCE_PATH: {
                    return this.sourcePath;
                }
                case SOURCE_OUTPUT: {
                    return this.sourceOutput;
                }
                case CLASS_OUTPUT: {
                    return this.classOutput;
                }
                case CLASS_PATH: {
                    return this.classPath;
                }
            }
        }
        return null;
    }

    @Override
    public Iterable<? extends JavaFileObject> getJavaFileObjectsFromFiles(Iterable<? extends File> files) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterable<? extends JavaFileObject> getJavaFileObjects(File ... files) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterable<? extends JavaFileObject> getJavaFileObjectsFromStrings(Iterable<String> names) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterable<? extends JavaFileObject> getJavaFileObjects(String ... names) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setLocation(JavaFileManager.Location location, Iterable<? extends File> path) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterable<? extends File> getLocation(JavaFileManager.Location location) {
        FileManager manager;
        if (location == StandardLocation.CLASS_PATH && (manager = this.getFiles(location)) != null) {
            try {
                HashSet<File> files = new HashSet<File>();
                manager.populateRoots(files);
                return files;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public JavaFileObject getJavaFileForInput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind) throws IOException {
        throw new UnsupportedOperationException("Does not seem used at the moment, for now we leave it as is");
    }

    @Override
    public Iterable<JavaFileObject> list(JavaFileManager.Location location, String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
        FileManager files;
        Iterable<JavaFileObject> ret = location == StandardLocation.PLATFORM_CLASS_PATH ? super.list(location, packageName, kinds, recurse) : ((files = this.getFiles(location)) != null ? files.list(packageName, kinds, recurse, new ArrayList()) : Collections.emptyList());
        return ret;
    }

    @Override
    public String inferBinaryName(JavaFileManager.Location location, JavaFileObject file) {
        if (file instanceof JavaFileObjectImpl) {
            JavaFileObjectImpl fileClass = (JavaFileObjectImpl)file;
            return fileClass.getKey().fqn;
        }
        return super.inferBinaryName(location, file);
    }

    @Override
    public FileObject getFileForInput(JavaFileManager.Location location, String packageName, String relativeName) throws IOException {
        FileKey key = FileKey.newResourceName(packageName, relativeName);
        FileManager files = this.getFiles(location);
        if (files != null) {
            return files.getReadable(key);
        }
        throw new FileNotFoundException("Cannot write: " + location);
    }

    @Override
    public FileObject getFileForOutput(JavaFileManager.Location location, String packageName, String relativeName, FileObject sibling) throws IOException {
        FileKey key = FileKey.newResourceName(packageName, relativeName);
        if (location == StandardLocation.SOURCE_PATH) {
            JavaFileObjectImpl file = this.sourcePath.getReadable(key);
            if (file == null) {
                throw new FileNotFoundException("Not found:" + key.toString());
            }
            return file;
        }
        FileManager files = this.getFiles(location);
        if (files != null) {
            return files.getWritable(key);
        }
        throw new FileNotFoundException("Cannot write: " + location);
    }

    @Override
    public boolean isSameFile(FileObject a, FileObject b) {
        FileKey ka = ((JavaFileObjectImpl)a).getKey();
        FileKey kb = ((JavaFileObjectImpl)b).getKey();
        return ka.equals(kb);
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
        FileManager files = this.getFiles(location);
        if (files != null) {
            FileKey key = FileKey.newJavaName(className, kind);
            return files.getWritable(key);
        }
        throw new UnsupportedOperationException("Location " + location + " not supported");
    }
}

