/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.bridge.module;

import java.net.URL;
import java.util.concurrent.atomic.AtomicInteger;
import juzu.impl.bridge.BridgeContext;
import juzu.impl.bridge.module.ApplicationBridge;
import juzu.impl.common.JSON;
import juzu.impl.common.Logger;
import juzu.impl.common.RunMode;
import juzu.impl.common.Tools;
import juzu.impl.fs.spi.ReadFileSystem;
import juzu.impl.plugin.module.ModuleContext;
import juzu.impl.resource.ResourceResolver;
import juzu.impl.runtime.ModuleRuntime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ModuleContextImpl
implements ModuleContext {
    final AtomicInteger leases;
    final BridgeContext bridgeContext;
    final ResourceResolver resolver;
    final ApplicationBridge bridge;
    final ModuleRuntime<?> runtime;
    final RunMode runMode;

    protected ModuleContextImpl(Logger log, ApplicationBridge bridge, BridgeContext bridgeContext, ResourceResolver resolver) {
        ModuleRuntime lifeCycle;
        RunMode runMode = bridge.getRunMode();
        if (runMode.isDynamic()) {
            ReadFileSystem<?> sourcePath = bridgeContext.getSourcePath();
            lifeCycle = new ModuleRuntime.Dynamic(log, Thread.currentThread().getContextClassLoader(), sourcePath);
        } else {
            ReadFileSystem<?> classPath = bridgeContext.getClassPath();
            lifeCycle = new ModuleRuntime.Static(log, Thread.currentThread().getContextClassLoader(), classPath);
        }
        this.bridgeContext = bridgeContext;
        this.resolver = resolver;
        this.bridge = bridge;
        this.runtime = lifeCycle;
        this.leases = new AtomicInteger();
        this.runMode = runMode;
    }

    @Override
    public JSON getConfig() throws Exception {
        ClassLoader classLoader = this.getClassLoader();
        URL cfg = classLoader.getResource("juzu/config.json");
        String s = Tools.read(cfg);
        return (JSON)JSON.parse(s);
    }

    @Override
    public ReadFileSystem<?> getResourcePath() {
        return this.bridgeContext.getResourcePath();
    }

    @Override
    public RunMode getRunMode() {
        return this.runMode;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.runtime.getClassLoader();
    }

    @Override
    public ResourceResolver getServerResolver() {
        return this.resolver;
    }

    public synchronized void lease() {
        this.leases.incrementAndGet();
    }

    public synchronized boolean release() {
        return this.leases.decrementAndGet() == 0;
    }
}

