/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.inject.spi.guice;

import com.google.inject.AbstractModule;
import com.google.inject.Binding;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.ProvisionException;
import com.google.inject.TypeLiteral;
import com.google.inject.binder.LinkedBindingBuilder;
import com.google.inject.internal.BindingImpl;
import com.google.inject.internal.Scoping;
import com.google.inject.matcher.Matchers;
import com.google.inject.name.Named;
import com.google.inject.spi.InjectionListener;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.PreDestroy;
import juzu.Scope;
import juzu.impl.common.Tools;
import juzu.impl.inject.ScopeController;
import juzu.impl.inject.spi.InjectionContext;
import juzu.impl.inject.spi.InjectorProvider;
import juzu.impl.inject.spi.guice.BeanAlias;
import juzu.impl.inject.spi.guice.BeanBinding;
import juzu.impl.inject.spi.guice.GuiceBean;
import juzu.impl.inject.spi.guice.GuiceInjector;
import juzu.impl.inject.spi.guice.GuiceScope;
import juzu.impl.inject.spi.guice.PostConstructInjectionListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GuiceContext
extends InjectionContext<GuiceBean, Object> {
    private Injector injector;
    private final ClassLoader classLoader;
    private final Map<String, Key<?>> nameMap;
    private final ScopeController scopeController = new ScopeController();

    public GuiceContext(final GuiceInjector bootstrap) {
        AbstractModule module = new AbstractModule(){

            protected void configure() {
                this.bindListener(Matchers.any(), new TypeListener(){

                    public <I> void hear(TypeLiteral<I> type, TypeEncounter<I> encounter) {
                        encounter.register((InjectionListener)new PostConstructInjectionListener());
                    }
                });
                for (Scope scope : bootstrap.scopes) {
                    if (scope.isBuiltIn()) continue;
                    this.bindScope(scope.getAnnotationType(), new GuiceScope(scope, GuiceContext.this.scopeController));
                }
                for (BeanBinding beanBinding : bootstrap.bindings) {
                    Object c;
                    BeanBinding d;
                    Key key;
                    if (beanBinding.qualifiers != null && beanBinding.qualifiers.size() > 0) {
                        Iterator<Annotation> i = beanBinding.qualifiers.iterator();
                        key = Key.get(beanBinding.type, (Annotation)i.next());
                    } else {
                        key = Key.get(beanBinding.type);
                    }
                    LinkedBindingBuilder b = this.bind(key);
                    if (beanBinding instanceof BeanBinding.ToInstance) {
                        d = (BeanBinding.ToInstance)beanBinding;
                        b.toInstance(d.instance);
                        c = b;
                        continue;
                    }
                    if (beanBinding instanceof BeanBinding.ToProviderInstance) {
                        d = (BeanBinding.ToProviderInstance)beanBinding;
                        c = b.toProvider((Provider)d);
                        if (beanBinding.scopeType == null) continue;
                        c.in(beanBinding.scopeType);
                        continue;
                    }
                    if (beanBinding instanceof BeanBinding.ToProviderType) {
                        d = (BeanBinding.ToProviderType)beanBinding;
                        c = b.toProvider(((BeanBinding.ToProviderType)d).provider);
                    } else {
                        d = (BeanBinding.ToType)beanBinding;
                        if (((BeanBinding.ToType)d).qualifiers != null) {
                            if (((BeanBinding.ToType)d).implementationType != null) {
                                c = b.to(((BeanBinding.ToType)d).implementationType);
                                this.bind(Key.get(((BeanBinding.ToType)d).implementationType, (Annotation)key.getAnnotation())).toProvider(new BeanAlias(key));
                            } else {
                                c = b.to(beanBinding.type);
                            }
                        } else {
                            c = ((BeanBinding.ToType)d).implementationType != null ? b.to(((BeanBinding.ToType)d).implementationType) : b;
                        }
                    }
                    if (beanBinding.scopeType == null) continue;
                    c.in(beanBinding.scopeType);
                }
                this.bind(InjectionContext.class).toInstance((Object)GuiceContext.this);
            }

            private <T> void bind(Class<T> clazz, T instance) {
                this.bind(clazz).toInstance(instance);
            }
        };
        HashMap nameMap = new HashMap();
        Injector injector = Guice.createInjector((Module[])new Module[]{module});
        for (Key key : injector.getBindings().keySet()) {
            Class annotationType = key.getAnnotationType();
            if (annotationType == null || !Named.class.isAssignableFrom(annotationType)) continue;
            Named named = (Named)key.getAnnotation();
            nameMap.put(named.value(), key);
        }
        this.injector = injector;
        this.nameMap = nameMap;
        this.classLoader = bootstrap.classLoader;
    }

    @Override
    public InjectorProvider getProvider() {
        return InjectorProvider.INJECT_GUICE;
    }

    @Override
    public ScopeController getScopeController() {
        return this.scopeController;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public GuiceBean resolveBean(Class<?> type) {
        Binding binding = this.injector.getBinding(type);
        return binding != null ? new GuiceBean(binding) : null;
    }

    @Override
    public Iterable<GuiceBean> resolveBeans(Class<?> type) {
        ArrayList<GuiceBean> beans = new ArrayList<GuiceBean>();
        Map allBindings = this.injector.getAllBindings();
        Collection bindings = allBindings.values();
        for (Binding binding : bindings) {
            Class bindingType = binding.getKey().getTypeLiteral().getRawType();
            if (!type.isAssignableFrom(bindingType)) continue;
            beans.add(new GuiceBean(binding));
        }
        return beans;
    }

    @Override
    public GuiceBean resolveBean(String name) {
        Key<?> key = this.nameMap.get(name);
        GuiceBean bean = null;
        if (key != null) {
            bean = new GuiceBean(this.injector.getBinding(key));
        }
        return bean;
    }

    @Override
    public Object create(GuiceBean bean) throws InvocationTargetException {
        try {
            return bean.binding.getProvider().get();
        }
        catch (ProvisionException e) {
            throw new InvocationTargetException(Tools.safeCause(e));
        }
    }

    @Override
    public Object get(GuiceBean bean, Object instance) throws InvocationTargetException {
        return instance;
    }

    @Override
    public void release(GuiceBean bean, Object instance) {
        Scoping scoping = ((BindingImpl)bean.binding).getScoping();
        if (scoping.isNoScope()) {
            GuiceContext.invokePreDestroy(instance);
        }
    }

    static void invokePreDestroy(Object o) {
        for (Method method : o.getClass().getMethods()) {
            if (!Modifier.isPublic(method.getModifiers()) || Modifier.isStatic(method.getModifiers()) || method.getAnnotation(PreDestroy.class) == null) continue;
            try {
                method.invoke(o, new Object[0]);
            }
            catch (IllegalAccessException e) {
                throw new UnsupportedOperationException("handle me gracefully", e);
            }
            catch (InvocationTargetException e) {
                throw new UnsupportedOperationException("handle me gracefully", e);
            }
        }
    }

    @Override
    public void close() {
        for (Binding binding : this.injector.getAllBindings().values()) {
            Scoping scoping = ((BindingImpl)binding).getScoping();
            if (scoping != Scoping.SINGLETON_INSTANCE) continue;
            GuiceContext.invokePreDestroy(binding.getProvider().get());
        }
    }
}

