/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.plugin.amd;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import juzu.PropertyType;
import juzu.asset.AssetLocation;
import juzu.impl.asset.AssetManager;
import juzu.impl.asset.AssetMetaData;
import juzu.impl.common.JSON;
import juzu.impl.plugin.PluginContext;
import juzu.impl.plugin.PluginDescriptor;
import juzu.impl.plugin.amd.AMDDependency;
import juzu.impl.plugin.amd.AMDDescriptor;
import juzu.impl.plugin.amd.Module;
import juzu.impl.plugin.amd.ModuleManager;
import juzu.impl.plugin.amd.ModuleMetaData;
import juzu.impl.plugin.application.ApplicationPlugin;
import juzu.impl.request.Request;
import juzu.impl.request.RequestFilter;
import juzu.io.Chunk;
import juzu.io.Stream;
import juzu.io.StreamableDecorator;
import juzu.request.Phase;
import juzu.request.Result;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AMDPlugin
extends ApplicationPlugin
implements RequestFilter {
    private Module[] defines;
    private Module[] requires;
    private AMDDescriptor descriptor;
    private PluginContext context;
    @Inject
    @Named(value="juzu.asset_manager.script")
    AssetManager scriptManager;
    @Inject
    ModuleManager manager;

    public AMDPlugin() {
        super("amd");
    }

    public ModuleManager getModuleManager() {
        return this.manager;
    }

    @Override
    public PluginDescriptor init(PluginContext context) throws Exception {
        JSON config = context.getConfig();
        List<ModuleMetaData.Define> defines = Collections.emptyList();
        List<ModuleMetaData.Require> requires = Collections.emptyList();
        if (config != null) {
            String packageName = config.getString("package");
            JSON definesJSON = config.getJSON("defines");
            JSON requiresJSON = config.getJSON("requires");
            if (definesJSON != null) {
                AssetLocation defineLocation = AssetLocation.safeValueOf(definesJSON.getString("location"));
                if (defineLocation == null) {
                    defineLocation = AssetLocation.APPLICATION;
                }
                defines = this.loadDefines(packageName, defineLocation, definesJSON.getList("value", JSON.class));
            }
            if (requiresJSON != null) {
                AssetLocation requireLocation = AssetLocation.safeValueOf(requiresJSON.getString("location"));
                if (requireLocation == null) {
                    requireLocation = AssetLocation.APPLICATION;
                }
                requires = this.loadRequires(packageName, requireLocation, requiresJSON.getList("value", JSON.class));
            }
        }
        this.descriptor = new AMDDescriptor(defines, requires);
        this.context = context;
        return this.descriptor;
    }

    private List<ModuleMetaData.Define> loadDefines(String packageName, AssetLocation defaultLocation, List<? extends JSON> modules) throws Exception {
        List<ModuleMetaData.Define> defines = Collections.emptyList();
        if (modules != null && modules.size() > 0) {
            defines = new ArrayList<ModuleMetaData.Define>();
            for (JSON jSON : modules) {
                String name = jSON.getString("id");
                List<?> dependencies = jSON.getList("dependencies");
                String value = jSON.getString("path");
                if (!value.startsWith("/")) {
                    value = "/" + this.application.getPackageName().replace('.', '/') + "/" + packageName.replace('.', '/') + "/" + value;
                }
                String adapter = jSON.getString("adapter");
                ModuleMetaData.Define descriptor = new ModuleMetaData.Define(name, value, adapter);
                if (dependencies != null && !dependencies.isEmpty()) {
                    for (JSON dependency : dependencies) {
                        String depName = dependency.getString("id");
                        String depAlias = dependency.getString("alias");
                        descriptor.addDependency(new AMDDependency(depName, depAlias));
                    }
                }
                defines.add(descriptor);
            }
        }
        return defines;
    }

    private List<ModuleMetaData.Require> loadRequires(String packageName, AssetLocation defaultLocation, List<? extends JSON> modules) throws Exception {
        List<ModuleMetaData.Require> defines = Collections.emptyList();
        if (modules != null && modules.size() > 0) {
            defines = new ArrayList<ModuleMetaData.Require>();
            for (JSON jSON : modules) {
                String value;
                String name = jSON.getString("id");
                AssetLocation location = AssetLocation.safeValueOf(jSON.getString("location"));
                if (location == null) {
                    location = defaultLocation;
                }
                if (!(value = jSON.getString("path")).startsWith("/") && location == AssetLocation.APPLICATION) {
                    value = "/" + this.application.getPackageName().replace('.', '/') + "/" + packageName.replace('.', '/') + "/" + value;
                }
                defines.add(new ModuleMetaData.Require(name, value, location));
            }
        }
        return defines;
    }

    @PostConstruct
    public void start() throws Exception {
        URL requirejsURL = AMDPlugin.class.getClassLoader().getResource("juzu/impl/plugin/amd/require.js");
        if (requirejsURL == null) {
            throw new Exception("Not found require.js");
        }
        URL wrapperjsURL = AMDPlugin.class.getClassLoader().getResource("juzu/impl/plugin/amd/wrapper.js");
        if (wrapperjsURL == null) {
            throw new Exception("Not found wrapper.js");
        }
        this.scriptManager.addAsset(new AssetMetaData("juzu.amd", AssetLocation.APPLICATION, "/juzu/impl/plugin/amd/require.js", new String[0]), requirejsURL);
        this.scriptManager.addAsset(new AssetMetaData("juzu.amd.wrapper", AssetLocation.APPLICATION, "/juzu/impl/plugin/amd/wrapper.js", new String[0]), wrapperjsURL);
        this.defines = this.process(this.descriptor.getDefines(), this.manager);
        this.requires = this.process(this.descriptor.getRequires(), this.manager);
    }

    private Module[] process(List<? extends ModuleMetaData> modules, ModuleManager manager) throws Exception {
        ArrayList<Module> assets = new ArrayList<Module>();
        for (ModuleMetaData moduleMetaData : modules) {
            URL url;
            AssetLocation location = moduleMetaData.getLocation();
            if (location == AssetLocation.APPLICATION) {
                String path = moduleMetaData.getPath();
                url = this.context.getApplicationResolver().resolve(path);
                if (url == null) {
                    throw new Exception("Could not resolve application asset " + moduleMetaData.getPath());
                }
            } else if (location == AssetLocation.SERVER) {
                if (!moduleMetaData.getPath().startsWith("/")) {
                    url = this.context.getServerResolver().resolve("/" + moduleMetaData.getPath());
                    if (url == null) {
                        throw new Exception("Could not resolve server asset " + moduleMetaData.getPath());
                    }
                } else {
                    url = null;
                }
            } else {
                url = null;
            }
            Module id = manager.addAMD(moduleMetaData, url);
            assets.add(id);
        }
        return assets.toArray(new Module[assets.size()]);
    }

    @Override
    public void invoke(Request request) {
        Result result;
        request.invoke();
        if (request.getPhase() == Phase.VIEW && (result = request.getResult()) instanceof Result.Status) {
            Result.Status status = (Result.Status)result;
            if (status.decorated && (this.defines.length > 0 || this.requires.length > 0)) {
                status = new Result.Status(status.code, true, new StreamableDecorator(status.streamable){

                    protected void sendHeader(Stream consumer) {
                        consumer.provide(new Chunk.Property<String>("juzu.amd", PropertyType.SCRIPT));
                        consumer.provide(new Chunk.Property<String>("juzu.amd.wrapper", PropertyType.SCRIPT));
                        for (Module define : AMDPlugin.this.defines) {
                            consumer.provide(new Chunk.Property<Module>(define, Module.TYPE));
                        }
                        for (Module require : AMDPlugin.this.requires) {
                            consumer.provide(new Chunk.Property<Module>(require, Module.TYPE));
                        }
                    }
                });
            }
            request.setResult(status);
        }
    }
}

