/*
 * Decompiled with CFR 0.152.
 */
package juzu.request;

import java.util.List;
import juzu.PropertyMap;
import juzu.Response;
import juzu.impl.common.Formatting;
import juzu.io.Streamable;
import juzu.request.Dispatch;

public class Result {

    public static class Status
    extends Result {
        public final int code;
        public final boolean decorated;
        public final Streamable streamable;

        public Status(int code, boolean decorated, Streamable streamable) {
            this.code = code;
            this.streamable = streamable;
            this.decorated = decorated;
        }
    }

    public static class Redirect
    extends Simple {
        public final String location;

        public Redirect(PropertyMap properties, String location) {
            super(properties);
            this.location = location;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Redirect) {
                Redirect that = (Redirect)obj;
                return this.location.equals(that.location);
            }
            return false;
        }

        public String toString() {
            return "Result.Redirect[location" + this.location + "]";
        }
    }

    public static class View
    extends Simple {
        public final Dispatch dispatch;

        public View(PropertyMap properties, Dispatch dispatch) {
            super(properties);
            this.dispatch = dispatch;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Error
    extends Simple {
        public final List<StackTraceElement> at;
        public final Throwable cause;
        public final String message;

        public Error(PropertyMap properties, List<StackTraceElement> at, Throwable cause, String message) {
            super(properties);
            this.at = at;
            this.cause = cause;
            this.message = message;
        }

        public Status asStatus(boolean verbose) {
            Response.Status response = Response.status(500);
            if (verbose) {
                StringBuilder buffer = new StringBuilder();
                Formatting.renderStyleSheet(buffer);
                buffer.append("<div class=\"juzu\">");
                buffer.append("<h1>Oups something went wrong</h1>");
                if (this.cause != null) {
                    Formatting.renderThrowable(null, buffer, this.cause);
                } else {
                    buffer.append(this.message);
                }
                buffer.append("</div>");
                response = response.content(buffer).withMimeType("text/html");
            }
            return response.result();
        }
    }

    public static abstract class Simple
    extends Result {
        public final PropertyMap properties;

        protected Simple(PropertyMap properties) {
            this.properties = properties;
        }
    }
}

