/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.inject.spi;

import java.util.HashMap;
import java.util.Map;
import juzu.impl.inject.spi.Injector;
import juzu.impl.inject.spi.cdi.provided.ProvidedCDIInjector;
import juzu.impl.inject.spi.cdi.weld.WeldInjector;
import juzu.impl.inject.spi.guice.GuiceInjector;
import juzu.impl.inject.spi.spring.SpringInjector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum InjectorProvider {
    CDI_WELD("weld"){

        public Injector get(boolean provided) {
            if (provided) {
                ClassLoader key = Thread.currentThread().getContextClassLoader();
                return ProvidedCDIInjector.get(key);
            }
            return new WeldInjector();
        }
    }
    ,
    INJECT_GUICE("guice"){

        public Injector get(boolean provided) {
            if (provided) {
                throw new UnsupportedOperationException("No provided mode for Guice");
            }
            return new GuiceInjector();
        }
    }
    ,
    INJECT_SPRING("spring"){

        public Injector get(boolean provided) {
            if (provided) {
                throw new UnsupportedOperationException("No provided mode for Spring");
            }
            return new SpringInjector();
        }
    };

    final String value;
    private static final Map<String, InjectorProvider> LOOKUP;

    public abstract Injector get(boolean var1);

    private InjectorProvider(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public static InjectorProvider find(String value) {
        return LOOKUP.get(value);
    }

    static {
        LOOKUP = new HashMap<String, InjectorProvider>();
        for (InjectorProvider injectorProvider : InjectorProvider.values()) {
            LOOKUP.put(injectorProvider.getValue(), injectorProvider);
        }
    }
}

