/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import juzu.io.OutputStream;

public abstract class BinaryStream
extends OutputStream {
    private final Charset charset;
    private CharsetEncoder encoder;
    private ByteBuffer bb;
    private CharBuffer single;

    protected BinaryStream(Charset charset) {
        this.charset = charset;
    }

    public void append(CharBuffer buffer) throws IOException {
        block7: {
            if (buffer.hasRemaining()) {
                CoderResult result;
                if (this.encoder == null) {
                    this.encoder = this.charset.newEncoder().onUnmappableCharacter(CodingErrorAction.REPORT).onMalformedInput(CodingErrorAction.IGNORE);
                    this.bb = ByteBuffer.allocate(512);
                } else {
                    this.encoder.reset();
                }
                while (true) {
                    CoderResult coderResult = result = buffer.hasRemaining() ? this.encoder.encode(buffer, this.bb, true) : this.encoder.flush(this.bb);
                    if (result.isUnderflow() || result.isOverflow()) {
                        this.bb.flip();
                        if (this.bb.hasRemaining()) {
                            this.append(this.bb);
                        }
                        this.bb.clear();
                        if (!result.isUnderflow()) continue;
                        if (buffer.remaining() > 0) {
                            throw new UnsupportedOperationException("We don't support this case yet");
                        }
                        break block7;
                    }
                    if (!result.isUnmappable()) break;
                    buffer.position(buffer.position() + result.length());
                }
                throw new UnsupportedOperationException("We don't support this case yet (2) " + result);
            }
        }
    }

    public void append(ByteBuffer buffer) throws IOException {
        this.append(this.bb.array(), this.bb.arrayOffset() + this.bb.position(), this.bb.limit() - this.bb.arrayOffset());
    }

    public void append(CharSequence csq) throws IOException {
        this.append(csq, 0, csq.length());
    }

    public void append(CharSequence csq, int start, int end) throws IOException {
        this.append(CharBuffer.wrap(csq, start, end));
    }

    public void append(char c) throws IOException {
        if (this.single == null) {
            this.single = CharBuffer.allocate(1);
        } else {
            this.single.compact();
        }
        this.single.put(c);
        this.single.flip();
        this.append(this.single);
    }
}

