/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.bridge.spi.servlet;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.AsyncContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import juzu.asset.AssetLocation;
import juzu.impl.bridge.spi.web.HttpStream;
import juzu.impl.bridge.spi.web.WebRequestContext;
import juzu.impl.common.FormURLEncodedParser;
import juzu.impl.common.Lexers;
import juzu.impl.common.Tools;
import juzu.impl.io.BinaryOutputStream;
import juzu.io.Stream;
import juzu.request.RequestParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletRequestContext
extends WebRequestContext {
    final HttpServletRequest req;
    final HttpServletResponse resp;
    final String path;
    final String requestPath;
    final Map<String, RequestParameter> requestParameters;
    final Charset defaultEncoding;

    public ServletRequestContext(Charset defaultEncoding, HttpServletRequest req, HttpServletResponse resp, String path) {
        Map requestParameters = Collections.emptyMap();
        String query = req.getQueryString();
        if (query != null) {
            Iterator<RequestParameter> i = Lexers.queryParser(query);
            while (i.hasNext()) {
                if (requestParameters.isEmpty()) {
                    requestParameters = new HashMap();
                }
                RequestParameter parameter = i.next();
                parameter.appendTo(requestParameters);
            }
        }
        if ("POST".equals(req.getMethod()) && "application/x-www-form-urlencoded".equals(req.getContentType())) {
            try {
                byte[] bytes = Tools.copy((InputStream)req.getInputStream(), new ByteArrayOutputStream()).toByteArray();
                String form = new String(bytes, defaultEncoding);
                FormURLEncodedParser parser = new FormURLEncodedParser(defaultEncoding, form, 0, form.length());
                for (RequestParameter parameter : parser) {
                    if (requestParameters.isEmpty()) {
                        requestParameters = new HashMap();
                    }
                    parameter.appendTo(requestParameters);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.defaultEncoding = defaultEncoding;
        this.requestPath = req.getRequestURI().substring(req.getContextPath().length());
        this.requestParameters = requestParameters;
        this.req = req;
        this.path = path;
        this.resp = resp;
    }

    @Override
    public Map<String, RequestParameter> getParameters() {
        return this.requestParameters;
    }

    @Override
    public String getRequestPath() {
        return this.requestPath;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getRequestURI() {
        return this.req.getRequestURI();
    }

    @Override
    public HttpStream getStream(int status) {
        return new ServletStream(status, this.defaultEncoding);
    }

    @Override
    public void setHeaders(Iterable<Map.Entry<String, String[]>> headers) {
        for (Map.Entry<String, String[]> header : headers) {
            this.resp.setHeader(header.getKey(), header.getValue()[0]);
        }
    }

    @Override
    public void sendRedirect(String location) throws IOException {
        this.resp.sendRedirect(location);
    }

    @Override
    public void setContentType(String mimeType, Charset charset) {
        String name = charset.name();
        this.resp.setCharacterEncoding(name);
        this.resp.setContentType(mimeType);
    }

    @Override
    public void setStatus(int status) {
        this.resp.setStatus(status);
    }

    @Override
    public void renderAssetURL(AssetLocation location, String uri, Appendable appendable) throws IOException {
        switch (location) {
            case SERVER: {
                if (!uri.startsWith("/")) {
                    appendable.append(this.req.getContextPath());
                    appendable.append('/');
                }
                appendable.append(uri);
                break;
            }
            case APPLICATION: {
                appendable.append(this.req.getContextPath()).append("/assets");
                appendable.append(uri);
                break;
            }
            case URL: {
                appendable.append(uri);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    public class ServletStream
    extends HttpStream {
        private Stream dataStream;
        private AsyncContext context;

        ServletStream(int status, Charset encoding) {
            super(ServletRequestContext.this, status, encoding);
        }

        public void setStatusCode(int status) {
            ServletRequestContext.this.resp.setStatus(status);
        }

        protected Stream getDataStream(boolean create) {
            if (this.dataStream == null && create) {
                try {
                    this.dataStream = new BinaryOutputStream(this.encoding, (OutputStream)ServletRequestContext.this.resp.getOutputStream());
                }
                catch (IOException e) {
                    throw new UnsupportedOperationException("Handle me gracefully", e);
                }
            }
            return this.dataStream;
        }

        protected void endAsync() {
            if (this.context != null) {
                System.out.println("COMPLETING ASYNC");
                this.context.complete();
            }
        }

        protected void beginAsync() {
            if (ServletRequestContext.this.req.isAsyncStarted()) {
                System.out.println("DETECTED ASYNC ALREADY STARTED");
                this.context = ServletRequestContext.this.req.getAsyncContext();
            } else {
                System.out.println("STARTING ASYNC");
                this.context = ServletRequestContext.this.req.startAsync();
            }
        }
    }
}

