/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.plugin.asset;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import juzu.PropertyMap;
import juzu.PropertyType;
import juzu.Response;
import juzu.asset.AssetLocation;
import juzu.impl.asset.AssetManager;
import juzu.impl.asset.AssetMetaData;
import juzu.impl.common.JSON;
import juzu.impl.plugin.PluginContext;
import juzu.impl.plugin.PluginDescriptor;
import juzu.impl.plugin.application.ApplicationPlugin;
import juzu.impl.plugin.asset.AssetDescriptor;
import juzu.impl.request.Request;
import juzu.impl.request.RequestFilter;
import juzu.request.Phase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssetPlugin
extends ApplicationPlugin
implements RequestFilter {
    private String[] scripts;
    private String[] declaredScripts;
    private String[] stylesheets;
    private String[] declaredStylesheets;
    private AssetDescriptor descriptor;
    private PluginContext context;
    @Inject
    @Named(value="juzu.asset_manager.script")
    AssetManager scriptManager;
    @Inject
    @Named(value="juzu.asset_manager.stylesheet")
    AssetManager stylesheetManager;

    public AssetPlugin() {
        super("asset");
    }

    public AssetManager getScriptManager() {
        return this.scriptManager;
    }

    public AssetManager getStylesheetManager() {
        return this.stylesheetManager;
    }

    @Override
    public PluginDescriptor init(PluginContext context) throws Exception {
        List<AssetMetaData> declaredStylesheets;
        List<AssetMetaData> stylesheets;
        List<AssetMetaData> declaredScripts;
        List<AssetMetaData> scripts;
        JSON config = context.getConfig();
        if (config != null) {
            String packageName = config.getString("package");
            AssetLocation location = AssetLocation.safeValueOf(config.getString("location"));
            if (location == null) {
                location = AssetLocation.APPLICATION;
            }
            scripts = this.load(packageName, location, config.getList("scripts", JSON.class));
            declaredScripts = this.load(packageName, location, config.getList("declaredScripts", JSON.class));
            stylesheets = this.load(packageName, location, config.getList("stylesheets", JSON.class));
            declaredStylesheets = this.load(packageName, location, config.getList("declaredStylesheets", JSON.class));
        } else {
            scripts = Collections.emptyList();
            declaredScripts = Collections.emptyList();
            stylesheets = Collections.emptyList();
            declaredStylesheets = Collections.emptyList();
        }
        this.descriptor = new AssetDescriptor(scripts, declaredScripts, stylesheets, declaredStylesheets);
        this.context = context;
        return this.descriptor;
    }

    private List<AssetMetaData> load(String packageName, AssetLocation defaultLocation, List<? extends JSON> scripts) throws Exception {
        List<AssetMetaData> abc = Collections.emptyList();
        if (scripts != null && scripts.size() > 0) {
            abc = new ArrayList<AssetMetaData>();
            for (JSON jSON : scripts) {
                String value;
                String id = jSON.getString("id");
                AssetLocation location = AssetLocation.safeValueOf(jSON.getString("location"));
                if (location == null) {
                    location = defaultLocation;
                }
                if (!(value = jSON.getString("src")).startsWith("/") && location == AssetLocation.APPLICATION) {
                    value = "/" + packageName.replace('.', '/') + "/" + value;
                }
                AssetMetaData descriptor = new AssetMetaData(id, location, value, jSON.getArray("depends", String.class));
                abc.add(descriptor);
            }
        }
        return abc;
    }

    @PostConstruct
    public void start() throws Exception {
        this.scripts = this.process(this.descriptor.getScripts(), this.scriptManager);
        this.declaredScripts = this.process(this.descriptor.getDeclaredScripts(), this.scriptManager);
        this.stylesheets = this.process(this.descriptor.getStylesheets(), this.stylesheetManager);
        this.declaredStylesheets = this.process(this.descriptor.getDeclaredStylesheets(), this.stylesheetManager);
    }

    private String[] process(List<AssetMetaData> data, AssetManager manager) throws Exception {
        ArrayList<String> assets = new ArrayList<String>();
        for (AssetMetaData script : data) {
            URL url;
            AssetLocation location = script.getLocation();
            if (location == AssetLocation.APPLICATION) {
                url = this.context.getApplicationResolver().resolve(script.getValue());
                if (url == null) {
                    throw new Exception("Could not resolve application  " + script.getValue());
                }
            } else if (location == AssetLocation.SERVER) {
                if (!script.getValue().startsWith("/")) {
                    url = this.context.getServerResolver().resolve("/" + script.getValue());
                    if (url == null) {
                        throw new Exception("Could not resolve server asset " + script.getValue());
                    }
                } else {
                    url = null;
                }
            } else {
                url = null;
            }
            String id = manager.addAsset(script, url);
            assets.add(id);
        }
        return assets.toArray(new String[assets.size()]);
    }

    @Override
    public void invoke(Request request) {
        Response response;
        request.invoke();
        if (request.getContext().getPhase() == Phase.VIEW && (response = request.getResponse()) instanceof Response.Content && (this.scripts.length > 0 || this.stylesheets.length > 0)) {
            Response.Content render = (Response.Content)response;
            PropertyMap properties = new PropertyMap(render.getProperties());
            properties.addValues(PropertyType.STYLESHEET, this.stylesheets);
            properties.addValues(PropertyType.SCRIPT, this.scripts);
            request.setResponse(new Response.Content(properties, render.getStreamable()));
        }
    }
}

