/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.asset;

import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import juzu.impl.asset.Asset;
import juzu.impl.asset.AssetMetaData;
import juzu.impl.asset.AssetNode;
import juzu.impl.common.Tools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssetManager {
    protected final LinkedHashMap<String, AssetNode> assets = new LinkedHashMap();
    protected final HashMap<String, URL> resources = new HashMap();

    public String addAsset(AssetMetaData data, URL url) throws NullPointerException, IllegalArgumentException {
        String id = data.id;
        if (id == null) {
            String value = data.getValue();
            int slash = value.lastIndexOf(47);
            String string = id = slash >= 0 ? value.substring(slash + 1) : value;
        }
        if (!this.assets.keySet().contains(id)) {
            AssetNode asset = new AssetNode(id, data.location, data.value, data.dependencies);
            for (AssetNode deployed : this.assets.values()) {
                if (deployed.iDependOn.contains(id)) {
                    asset.dependsOnMe = Tools.addToHashSet(asset.dependsOnMe, deployed.id);
                }
                if (!asset.iDependOn.contains(deployed.id)) continue;
                deployed.dependsOnMe = Tools.addToHashSet(deployed.dependsOnMe, id);
            }
            this.assets.put(id, asset);
            switch (data.location) {
                case APPLICATION: 
                case SERVER: {
                    this.resources.put(data.getValue(), url);
                    break;
                }
            }
        }
        return id;
    }

    public URL resolveAsset(String path) {
        return this.resources.get(path);
    }

    public Iterable<Asset> resolveAssets(Iterable<String> ids) throws NullPointerException, IllegalArgumentException {
        LinkedHashMap<String, HashSet<String>> sub = new LinkedHashMap<String, HashSet<String>>();
        LinkedList<String> queue = Tools.addAll(new LinkedList(), ids);
        while (!queue.isEmpty()) {
            String id = (String)queue.removeFirst();
            AssetNode asset = this.assets.get(id);
            if (asset != null) {
                sub.put(asset.id, new HashSet<String>(asset.iDependOn));
                for (String string : asset.iDependOn) {
                    if (sub.containsKey(string)) continue;
                    queue.addLast(string);
                }
                continue;
            }
            throw new IllegalArgumentException("Cannot resolve asset " + id);
        }
        LinkedList<Asset> resolved = new LinkedList<Asset>();
        while (sub.size() > 0) {
            boolean found = false;
            Iterator i = sub.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                if (!((HashSet)entry.getValue()).isEmpty()) continue;
                i.remove();
                AssetNode assetNode = this.assets.get(entry.getKey());
                resolved.addLast(Asset.of(assetNode.getLocation(), assetNode.getValue()));
                for (String dependency : assetNode.dependsOnMe) {
                    HashSet foo = (HashSet)sub.get(dependency);
                    if (foo == null) continue;
                    foo.remove(entry.getKey());
                }
                found = true;
                break;
            }
            if (found) continue;
            StringBuilder sb = new StringBuilder("Cannot satisfy asset dependencies:\n");
            for (Map.Entry entry : sub.entrySet()) {
                sb.append((String)entry.getKey()).append(" -> ").append(entry.getValue());
            }
            throw new IllegalArgumentException(sb.toString());
        }
        return resolved;
    }
}

