/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.plugin.template.metamodel;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.tools.FileObject;
import juzu.impl.common.Content;
import juzu.impl.common.CycleDetectionException;
import juzu.impl.common.MethodInvocation;
import juzu.impl.common.Path;
import juzu.impl.common.Resource;
import juzu.impl.common.Timestamped;
import juzu.impl.common.Tools;
import juzu.impl.compiler.ProcessingContext;
import juzu.impl.compiler.ProcessingException;
import juzu.impl.plugin.controller.metamodel.ControllersMetaModel;
import juzu.impl.plugin.controller.metamodel.MethodMetaModel;
import juzu.impl.plugin.controller.metamodel.ParameterMetaModel;
import juzu.impl.plugin.controller.metamodel.PhaseParameterMetaModel;
import juzu.impl.plugin.template.metamodel.AbstractContainerMetaModel;
import juzu.impl.plugin.template.metamodel.TemplateMetaModel;
import juzu.impl.plugin.template.metamodel.TemplateRefMetaModel;
import juzu.impl.template.spi.ParseContext;
import juzu.impl.template.spi.ProcessContext;
import juzu.impl.template.spi.Template;
import juzu.impl.template.spi.TemplateException;
import juzu.impl.template.spi.TemplateProvider;
import juzu.template.TagHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MetaModelProcessContext
extends ProcessContext {
    private AbstractContainerMetaModel owner;
    private final ProcessingContext env;
    private final Collection<? extends TemplateRefMetaModel> refs;

    MetaModelProcessContext(AbstractContainerMetaModel owner, Collection<? extends TemplateRefMetaModel> refs) {
        this.refs = refs;
        this.owner = owner;
        this.env = owner.application.getProcessingContext();
    }

    void resolve(TemplateMetaModel metaModel) throws TemplateException {
        Path.Absolute abs = this.owner.getQN().resolve(metaModel.path);
        this.resolveTemplate(abs);
    }

    @Override
    public TagHandler resolveTagHandler(String name) {
        return this.owner.resolveTagHandler(name);
    }

    @Override
    protected Path.Absolute resolvePath(Path.Relative path) {
        return this.owner.resolvePath(path);
    }

    @Override
    protected <M extends Serializable> Template<M> getTemplate(Path.Absolute path) {
        TemplateMetaModel tmm = this.owner.get(path);
        if (tmm != null) {
            return tmm.template;
        }
        return null;
    }

    @Override
    protected <M extends Serializable> M parseTemplate(TemplateProvider<M> provider, Path.Absolute path, CharSequence s) throws TemplateException {
        try {
            return provider.parse(new ParseContext(), s);
        }
        catch (TemplateException e) {
            throw TemplateMetaModel.TEMPLATE_SYNTAX_ERROR.failure(path);
        }
    }

    @Override
    protected <M extends Serializable> void processTemplate(TemplateProvider<M> provider, Template<M> template) throws TemplateException {
        Path.Absolute path = template.getPath();
        if (this.owner.getQN().isPrefix(path.getName())) {
            TemplateMetaModel metaModel;
            if (!this.refs.isEmpty()) {
                if (this.owner.templates.get(path) != null) {
                    throw new AssertionError();
                }
                for (TemplateRefMetaModel templateRefMetaModel : this.refs) {
                    this.owner.add(path, templateRefMetaModel);
                }
            }
            if ((metaModel = this.owner.templates.get(path)) == null) {
                throw new AssertionError();
            }
            metaModel.template = template;
            try {
                provider.process(new MetaModelProcessContext(this.owner, Collections.singletonList(metaModel)), template);
            }
            catch (TemplateException e) {
                throw TemplateMetaModel.TEMPLATE_VALIDATION_ERROR.failure(path);
            }
        } else {
            throw new AssertionError((Object)"Should not happen");
        }
    }

    @Override
    protected <M extends Serializable> void linkTemplate(Template<M> template) {
        TemplateMetaModel a = this.owner.get(template.getPath());
        for (TemplateRefMetaModel templateRefMetaModel : this.refs) {
            try {
                templateRefMetaModel.add(a);
            }
            catch (CycleDetectionException e) {
                StringBuilder path = new StringBuilder();
                for (Object node : e.getPath()) {
                    if (path.length() > 0) {
                        path.append("->");
                    }
                    if (node instanceof TemplateMetaModel) {
                        TemplateMetaModel templateNode = (TemplateMetaModel)node;
                        path.append(templateNode.getPath().getValue());
                        continue;
                    }
                    path.append(node);
                }
                throw TemplateMetaModel.TEMPLATE_CYCLE.failure(template.getPath(), path);
            }
        }
    }

    @Override
    protected TemplateProvider resolverProvider(String ext) {
        return this.owner.resolveTemplateProvider(ext);
    }

    @Override
    public MethodInvocation resolveMethodInvocation(String typeName, String methodName, Map<String, String> parameterMap) throws ProcessingException {
        MethodMetaModel method = this.owner.getApplication().getChild(ControllersMetaModel.KEY).resolve(typeName, methodName, parameterMap.keySet());
        if (method == null) {
            return null;
        }
        ArrayList<String> args = new ArrayList<String>();
        for (ParameterMetaModel param : method.getParameters()) {
            if (!(param instanceof PhaseParameterMetaModel)) continue;
            String value = parameterMap.get(param.getName());
            args.add(value);
        }
        return new MethodInvocation(method.getController().getHandle().getFQN() + "_", method.getName(), args);
    }

    @Override
    public Resource<Timestamped<Content>> resolveResource(Path.Absolute path) {
        FileObject resource = this.owner.application.resolveResource(path);
        if (resource != null) {
            try {
                byte[] bytes = Tools.bytes(resource.openInputStream());
                long lastModified = resource.getLastModified();
                Timestamped<Content> content = new Timestamped<Content>(lastModified, new Content(bytes, Charset.defaultCharset()));
                return new Resource<Timestamped<Content>>(path, content);
            }
            catch (Exception e) {
                this.env.log("Could not get resource content " + path.getCanonical(), e);
            }
        }
        return null;
    }
}

