/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.compiler.file;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import juzu.impl.common.FileKey;
import juzu.impl.common.Spliterator;
import juzu.impl.compiler.file.FileManager;
import juzu.impl.compiler.file.JavaFileObjectImpl;
import juzu.impl.fs.spi.ReadFileSystem;
import juzu.impl.fs.spi.ReadWriteFileSystem;
import juzu.impl.fs.spi.disk.DiskFileSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleFileManager<P>
extends FileManager {
    final StandardLocation location;
    final ReadFileSystem<P> fs;
    final Map<FileKey, JavaFileObjectImpl<P>> entries;

    public static <P> SimpleFileManager<P> wrap(StandardLocation location, ReadFileSystem<P> fs) {
        return new SimpleFileManager<P>(location, fs);
    }

    public SimpleFileManager(StandardLocation location, ReadFileSystem<P> fs) {
        this.location = location;
        this.fs = fs;
        this.entries = new HashMap<FileKey, JavaFileObjectImpl<P>>();
    }

    public ReadFileSystem<P> getFileSystem() {
        return this.fs;
    }

    @Override
    public void populateRoots(Set<File> roots) throws IOException {
        if (this.fs instanceof DiskFileSystem) {
            roots.add(((DiskFileSystem)this.fs).getRoot());
        }
    }

    @Override
    public void clearCache() {
        this.entries.clear();
    }

    @Override
    public JavaFileObjectImpl getReadable(FileKey key) throws IOException {
        P file;
        JavaFileObjectImpl<P> entry = this.entries.get(key);
        if (entry == null && (file = this.fs.getPath(key.names)) != null && this.fs.isFile(file)) {
            entry = new JavaFileObjectImpl<P>(this.location, key, this.fs, file);
            this.entries.put(key, entry);
        }
        return entry;
    }

    @Override
    public JavaFileObjectImpl getWritable(FileKey key) throws IOException {
        JavaFileObjectImpl<P> entry = this.getReadable(key);
        if (entry == null) {
            if (this.fs instanceof ReadWriteFileSystem) {
                ReadWriteFileSystem rwFS = (ReadWriteFileSystem)this.fs;
                Object file = rwFS.makePath(key.names);
                entry = new JavaFileObjectImpl<P>(this.location, key, this.fs, file);
                this.entries.put(key, entry);
            } else {
                throw new IOException("File system is not writable");
            }
        }
        return entry;
    }

    @Override
    public <C extends Collection<JavaFileObject>> C list(String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse, C to) throws IOException {
        Iterable<String> packageNames = Spliterator.split(packageName, '.');
        P dir = this.fs.getPath(packageNames);
        if (dir != null && this.fs.isDir(dir)) {
            this.list(packageName, dir, kinds, recurse, to);
        }
        return to;
    }

    private void list(String packageName, P root, Set<JavaFileObject.Kind> kinds, boolean recurse, Collection<JavaFileObject> to) throws IOException {
        Iterator<P> i = this.fs.getChildren(root);
        while (i.hasNext()) {
            String name;
            P child = i.next();
            if (this.fs.isDir(child)) {
                if (!recurse) continue;
                name = this.fs.getName(child);
                this.list(packageName.isEmpty() ? name : packageName + "." + name, child, kinds, true, to);
                continue;
            }
            name = this.fs.getName(child);
            FileKey key = FileKey.newName(packageName, name);
            if (!kinds.contains((Object)key.getKind())) continue;
            to.add(this.getReadable(key));
        }
    }
}

