/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.inject.spi.cdi;

import java.io.InputStream;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.BeforeShutdown;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.ProcessBean;
import javax.inject.Singleton;
import juzu.Scope;
import juzu.impl.common.JSON;
import juzu.impl.common.Tools;
import juzu.impl.inject.spi.InjectionContext;
import juzu.impl.inject.spi.cdi.AbstractBean;
import juzu.impl.inject.spi.cdi.CDIContext;
import juzu.impl.inject.spi.cdi.ContextImpl;
import juzu.impl.inject.spi.cdi.SingletonBean;
import juzu.impl.inject.spi.cdi.provided.ProvidedCDIInjector;
import juzu.impl.plugin.application.Application;
import juzu.impl.plugin.application.descriptor.ApplicationDescriptor;
import juzu.impl.resource.ResourceResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionImpl
implements Extension {
    private CDIContext context = CDIContext.boot.get();
    private final List<Bean<?>> singletons = new ArrayList();

    void beforeBeanDiscovery(@Observes BeforeBeanDiscovery event, BeanManager beanManager) {
        if (this.context == null) {
            try {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                InputStream in = cl.getResourceAsStream("juzu/config.json");
                String serializedConfig = Tools.read(in);
                JSON config = (JSON)JSON.parse(serializedConfig);
                JSON applications = config.getJSON("application");
                if (applications.names().size() != 1) {
                    throw new RuntimeException("Was expecting application size to be 1 instead of " + applications);
                }
                String packageFQN = applications.names().iterator().next();
                ApplicationDescriptor descriptor = ApplicationDescriptor.create(cl, packageFQN);
                ResourceResolver resourceResolver = new ResourceResolver(){

                    public URL resolve(String uri) {
                        return null;
                    }
                };
                ProvidedCDIInjector injector = new ProvidedCDIInjector(cl, beanManager, descriptor, resourceResolver);
                Application application = injector.getApplication();
                application.start();
                this.context = (CDIContext)application.getInjectionContext();
            }
            catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    <T> void processAnnotatedType(@Observes ProcessAnnotatedType<T> pat) {
        boolean veto;
        AnnotatedType annotatedType = pat.getAnnotatedType();
        Class type = annotatedType.getJavaClass();
        boolean bl = veto = !this.context.filter.accept(type);
        if (!veto) {
            for (AbstractBean boundBean : this.context.injector.boundBeans) {
                Class<?> beanType = boundBean.getBeanClass();
                if (!beanType.isAssignableFrom(type)) continue;
                veto = true;
                break;
            }
        }
        if (veto) {
            pat.veto();
        }
    }

    void afterBeanDiscovery(@Observes AfterBeanDiscovery event, BeanManager beanManager) {
        for (Scope scope : this.context.injector.scopes) {
            if (scope.isBuiltIn()) continue;
            event.addContext((Context)new ContextImpl(this.context.injector.scopeController, scope, scope.getAnnotationType()));
        }
        event.addBean((Bean)new SingletonBean(InjectionContext.class, Tools.set(AbstractBean.DEFAULT_QUALIFIER, AbstractBean.ANY_QUALIFIER), this.context));
        for (AbstractBean bean : this.context.injector.boundBeans) {
            bean.register(beanManager);
            event.addBean((Bean)bean);
        }
    }

    void processBean(@Observes ProcessBean event, BeanManager beanManager) {
        Bean bean = event.getBean();
        this.context.beans.add(bean);
        if (bean.getScope() == Singleton.class) {
            this.singletons.add(bean);
        }
    }

    public void beforeShutdown(@Observes BeforeShutdown event, BeanManager beanManager) {
        for (Bean<?> singleton : this.singletons) {
            CreationalContext cc = beanManager.createCreationalContext(singleton);
            Object o = beanManager.getReference(singleton, (Type)singleton.getBeanClass(), cc);
            singleton.destroy(o, cc);
        }
    }
}

