/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.plugin.amd;

import java.util.LinkedHashMap;
import java.util.Map;
import juzu.asset.AssetLocation;
import juzu.impl.plugin.amd.AMDDependency;

public abstract class ModuleMetaData {
    private final String id;
    private final String path;

    public ModuleMetaData(String id, String path) {
        this.id = id;
        this.path = path;
    }

    public String getId() {
        return this.id;
    }

    public String getPath() {
        return this.path;
    }

    public abstract AssetLocation getLocation();

    public static class Require
    extends ModuleMetaData {
        final AssetLocation location;

        public Require(String name, String path, AssetLocation location) {
            super(name, path);
            this.location = location;
        }

        public AssetLocation getLocation() {
            return this.location;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Define
    extends ModuleMetaData {
        private final Map<String, AMDDependency> dependencies = new LinkedHashMap<String, AMDDependency>();
        private final String adapter;

        public Define(String name, String path, String adapter) {
            super(name, path);
            this.adapter = adapter;
        }

        public String getAdapter() {
            return this.adapter;
        }

        public void addDependency(AMDDependency dependency) {
            this.dependencies.put(dependency.name, dependency);
        }

        public Iterable<AMDDependency> getDependencies() {
            return this.dependencies.values();
        }

        @Override
        public AssetLocation getLocation() {
            return AssetLocation.APPLICATION;
        }
    }
}

