/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.bridge.spi.portlet;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.RejectedExecutionException;
import javax.portlet.MimeResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletModeException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletSession;
import javax.portlet.PortletURL;
import javax.portlet.ResourceURL;
import javax.portlet.WindowState;
import javax.portlet.WindowStateException;
import juzu.PropertyMap;
import juzu.PropertyType;
import juzu.Scope;
import juzu.asset.AssetLocation;
import juzu.bridge.portlet.JuzuPortlet;
import juzu.impl.asset.Asset;
import juzu.impl.bridge.Bridge;
import juzu.impl.bridge.spi.DispatchBridge;
import juzu.impl.bridge.spi.RequestBridge;
import juzu.impl.bridge.spi.ScopedContext;
import juzu.impl.bridge.spi.portlet.PortletApplicationContext;
import juzu.impl.bridge.spi.portlet.PortletHttpContext;
import juzu.impl.bridge.spi.portlet.PortletSecurityContext;
import juzu.impl.bridge.spi.portlet.PortletUserContext;
import juzu.impl.bridge.spi.portlet.PortletWindowContext;
import juzu.impl.bridge.spi.servlet.ServletScopedContext;
import juzu.impl.common.JUL;
import juzu.impl.common.Logger;
import juzu.impl.common.MethodHandle;
import juzu.impl.common.MimeType;
import juzu.impl.common.RunMode;
import juzu.impl.common.Tools;
import juzu.impl.plugin.controller.ControllerPlugin;
import juzu.impl.plugin.controller.ControllerResolver;
import juzu.impl.request.ControlParameter;
import juzu.impl.request.Method;
import juzu.impl.request.Request;
import juzu.io.UndeclaredIOException;
import juzu.request.ApplicationContext;
import juzu.request.HttpContext;
import juzu.request.Phase;
import juzu.request.RequestParameter;
import juzu.request.ResponseParameter;
import juzu.request.Result;
import juzu.request.SecurityContext;
import juzu.request.UserContext;
import juzu.request.WindowContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PortletRequestBridge<Rq extends PortletRequest, Rs extends PortletResponse>
implements RequestBridge {
    protected final Bridge bridge;
    protected final Rq req;
    protected final Rs resp;
    protected final Method<?> target;
    protected final HashMap<ControlParameter, Object> arguments;
    protected final Map<String, RequestParameter> requestParameters;
    protected final PortletHttpContext httpContext;
    protected final PortletSecurityContext securityContext;
    protected final PortletWindowContext windowContext;
    protected final PortletUserContext userContext;
    protected final PortletApplicationContext applicationContext;
    private final Phase phase;
    protected Request request;
    protected Result result;

    PortletRequestBridge(Bridge bridge, Phase phase, Rq req, Rs resp, PortletConfig config) {
        String methodId = null;
        HashMap parameters = new HashMap(req.getParameterMap());
        Map<String, RequestParameter> requestParameters = Collections.emptyMap();
        Iterator i = parameters.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<String, String[]> parameter = i.next();
            String name = (String)parameter.getKey();
            if (name.startsWith("juzu.")) {
                if (name.equals("juzu.op")) {
                    methodId = ((String[])parameter.getValue())[0];
                }
                i.remove();
                continue;
            }
            if (requestParameters.isEmpty()) {
                requestParameters = new HashMap();
            }
            requestParameters.put(name, RequestParameter.create(parameter));
        }
        ControllerResolver<Method> resolver = bridge.getApplication().resolveBean(ControllerPlugin.class).getResolver();
        Method target = methodId != null ? resolver.resolveMethod(phase, methodId, parameters.keySet()) : resolver.resolve(phase, parameters.keySet());
        HashMap<ControlParameter, Object> arguments = new HashMap<ControlParameter, Object>(target.getArguments(requestParameters));
        this.bridge = bridge;
        this.req = req;
        this.resp = resp;
        this.target = target;
        this.arguments = arguments;
        this.httpContext = new PortletHttpContext((PortletRequest)req);
        this.securityContext = new PortletSecurityContext((PortletRequest)req);
        this.windowContext = new PortletWindowContext(this);
        this.userContext = new PortletUserContext((PortletRequest)req);
        this.applicationContext = new PortletApplicationContext(config);
        this.requestParameters = requestParameters;
        this.phase = phase;
    }

    PortletRequestBridge(Bridge bridge, Phase phase, Rq req, Rs resp, PortletConfig config, Method<?> target, Map<String, String[]> parameters) {
        Map<String, RequestParameter> requestParameters = Collections.emptyMap();
        for (Map.Entry<String, String[]> parameter : parameters.entrySet()) {
            if (requestParameters.isEmpty()) {
                requestParameters = new HashMap<String, RequestParameter>();
            }
            RequestParameter.create(parameter).appendTo(requestParameters);
        }
        HashMap<ControlParameter, Object> arguments = new HashMap<ControlParameter, Object>(target.getArguments(requestParameters));
        this.phase = phase;
        this.bridge = bridge;
        this.req = req;
        this.resp = resp;
        this.target = target;
        this.arguments = arguments;
        this.requestParameters = requestParameters;
        this.httpContext = new PortletHttpContext((PortletRequest)req);
        this.securityContext = new PortletSecurityContext((PortletRequest)req);
        this.windowContext = new PortletWindowContext(this);
        this.userContext = new PortletUserContext((PortletRequest)req);
        this.applicationContext = new PortletApplicationContext(config);
    }

    @Override
    public final Logger getLogger(String name) {
        return JUL.getLogger(name);
    }

    @Override
    public final Phase getPhase() {
        return this.phase;
    }

    @Override
    public Map<String, RequestParameter> getRequestParameters() {
        return this.requestParameters;
    }

    @Override
    public Map<ControlParameter, Object> getArguments() {
        return this.arguments;
    }

    @Override
    public <T> T getProperty(PropertyType<T> propertyType) {
        Object propertyValue = null;
        if (JuzuPortlet.PORTLET_MODE.equals(propertyType)) {
            propertyValue = this.req.getPortletMode();
        } else if (JuzuPortlet.WINDOW_STATE.equals(propertyType)) {
            propertyValue = this.req.getWindowState();
        }
        if (RunMode.PROPERTY.equals(propertyType)) {
            propertyValue = this.bridge.getRunMode();
        }
        return propertyValue == null ? null : (T)propertyType.cast(propertyValue);
    }

    @Override
    public MethodHandle getTarget() {
        return this.target.getHandle();
    }

    @Override
    public final HttpContext getHttpContext() {
        return this.httpContext;
    }

    @Override
    public final SecurityContext getSecurityContext() {
        return this.securityContext;
    }

    @Override
    public final WindowContext getWindowContext() {
        return this.windowContext;
    }

    @Override
    public final UserContext getUserContext() {
        return this.userContext;
    }

    @Override
    public final ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    @Override
    public void execute(Runnable runnable) throws RejectedExecutionException {
        throw new RejectedExecutionException();
    }

    @Override
    public void close() {
    }

    @Override
    public final ScopedContext getScopedContext(Scope scope, boolean create) {
        ScopedContext context;
        Logger log = this.bridge.context.getLogger(ServletScopedContext.class.getName());
        switch (scope) {
            case REQUEST: {
                context = (ScopedContext)this.req.getAttribute("juzu.request_scope");
                if (context != null || !create) break;
                context = new ServletScopedContext(log);
                this.req.setAttribute("juzu.request_scope", (Object)context);
                break;
            }
            case FLASH: {
                PortletSession session = this.req.getPortletSession(create);
                if (session != null) {
                    context = (ScopedContext)session.getAttribute("juzu.flash_scope");
                    if (context != null || !create) break;
                    context = new ServletScopedContext(log);
                    session.setAttribute("juzu.flash_scope", (Object)context);
                    break;
                }
                context = null;
                break;
            }
            case SESSION: {
                PortletSession session = this.req.getPortletSession(create);
                if (session != null) {
                    context = (ScopedContext)session.getAttribute("juzu.session_scope");
                    if (context != null || !create) break;
                    context = new ServletScopedContext(log);
                    session.setAttribute("juzu.session_scope", (Object)context);
                    break;
                }
                context = null;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported scope " + (Object)((Object)scope));
            }
        }
        return context;
    }

    @Override
    public final void setResult(Result result) throws IllegalArgumentException, IOException {
        this.result = result;
    }

    @Override
    public void begin(Request request) {
        this.request = request;
    }

    @Override
    public void end() {
        this.request = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke() throws Exception {
        try {
            this.bridge.getApplication().resolveBean(ControllerPlugin.class).invoke(this);
        }
        finally {
            Tools.safeClose(this);
        }
    }

    public abstract void send() throws IOException, PortletException;

    private <T> String _checkPropertyValidity(Phase phase, PropertyType<T> propertyType, T propertyValue) {
        if (propertyType == JuzuPortlet.PORTLET_MODE) {
            if (phase == Phase.RESOURCE) {
                return "Resource URL don't have portlet modes";
            }
            PortletMode portletMode = (PortletMode)propertyValue;
            Enumeration e = this.req.getPortalContext().getSupportedPortletModes();
            while (e.hasMoreElements()) {
                PortletMode next = (PortletMode)e.nextElement();
                if (!next.equals((Object)portletMode)) continue;
                return null;
            }
            return "Unsupported portlet mode " + portletMode;
        }
        if (propertyType == JuzuPortlet.WINDOW_STATE) {
            if (phase == Phase.RESOURCE) {
                return "Resource URL don't have windwo state";
            }
            WindowState windowState = (WindowState)propertyValue;
            Enumeration e = this.req.getPortalContext().getSupportedWindowStates();
            while (e.hasMoreElements()) {
                WindowState next = (WindowState)e.nextElement();
                if (!next.equals((Object)windowState)) continue;
                return null;
            }
            return "Unsupported window state " + windowState;
        }
        return null;
    }

    @Override
    public DispatchBridge createDispatch(final Phase phase, final MethodHandle target, final Map<String, ResponseParameter> parameters) throws NullPointerException, IllegalArgumentException {
        return new DispatchBridge(){

            @Override
            public MethodHandle getTarget() {
                return target;
            }

            @Override
            public Map<String, ResponseParameter> getParameters() {
                return parameters;
            }

            @Override
            public <T> String checkPropertyValidity(PropertyType<T> propertyType, T propertyValue) {
                return PortletRequestBridge.this._checkPropertyValidity(phase, propertyType, propertyValue);
            }

            @Override
            public void renderURL(PropertyMap properties, MimeType mimeType, Appendable appendable) throws IOException {
                if (PortletRequestBridge.this.resp instanceof MimeResponse) {
                    PortletURL url;
                    MimeResponse mimeResp = (MimeResponse)PortletRequestBridge.this.resp;
                    Method method = PortletRequestBridge.this.bridge.getApplication().resolveBean(ControllerPlugin.class).getDescriptor().getMethodByHandle(target);
                    if (method.getPhase() == Phase.ACTION) {
                        url = mimeResp.createActionURL();
                    } else if (method.getPhase() == Phase.VIEW) {
                        url = mimeResp.createRenderURL();
                    } else if (method.getPhase() == Phase.RESOURCE) {
                        url = mimeResp.createResourceURL();
                    } else {
                        throw new AssertionError();
                    }
                    for (ResponseParameter parameter : parameters.values()) {
                        url.setParameter(parameter.getName(), parameter.toArray());
                    }
                    boolean escapeXML = false;
                    if (properties != null) {
                        WindowState windowStateProperty;
                        PortletMode portletModeProperty;
                        Boolean escapeXMLProperty = properties.getValue(PropertyType.ESCAPE_XML);
                        if (escapeXMLProperty != null && Boolean.TRUE.equals(escapeXMLProperty)) {
                            escapeXML = true;
                        }
                        if ((portletModeProperty = properties.getValue(JuzuPortlet.PORTLET_MODE)) != null) {
                            if (url instanceof PortletURL) {
                                try {
                                    url.setPortletMode(portletModeProperty);
                                }
                                catch (PortletModeException e) {
                                    throw new IllegalArgumentException(e);
                                }
                            } else {
                                throw new IllegalArgumentException();
                            }
                        }
                        if ((windowStateProperty = properties.getValue(JuzuPortlet.WINDOW_STATE)) != null) {
                            if (url instanceof PortletURL) {
                                try {
                                    url.setWindowState(windowStateProperty);
                                }
                                catch (WindowStateException e) {
                                    throw new IllegalArgumentException(e);
                                }
                            } else {
                                throw new IllegalArgumentException();
                            }
                        }
                        url.setParameter("juzu.op", method.getId());
                    }
                    if (escapeXML) {
                        StringWriter writer = new StringWriter();
                        url.write((Writer)writer, true);
                        appendable.append(writer.toString());
                    } else {
                        appendable.append(url.toString());
                    }
                } else {
                    throw new IllegalStateException("Cannot render an URL during phase " + phase);
                }
            }
        };
    }

    public PortletRequest getPortletRequest() {
        return this.req;
    }

    public PortletResponse getPortletResponse() {
        return this.resp;
    }

    @Override
    public void renderAssetURL(AssetLocation location, String uri, Appendable appendable) throws NullPointerException, UnsupportedOperationException, IOException {
        switch (location) {
            case SERVER: {
                if (!uri.startsWith("/")) {
                    appendable.append(this.req.getContextPath());
                    appendable.append('/');
                }
                appendable.append(uri);
                break;
            }
            case APPLICATION: {
                if (this.bridge.getRunMode().isStatic()) {
                    appendable.append(this.req.getContextPath()).append("/assets");
                    if (!uri.startsWith("/")) {
                        appendable.append('/');
                    }
                    appendable.append(uri);
                    break;
                }
                if (this.resp instanceof MimeResponse) {
                    ResourceURL r = ((MimeResponse)this.resp).createResourceURL();
                    r.setParameter("juzu.request", "assets");
                    r.setResourceID(uri);
                    break;
                }
                throw new UnsupportedOperationException("todo");
            }
            case URL: {
                appendable.append(uri);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    String getAssetURL(Asset asset) {
        StringBuilder sb = new StringBuilder();
        try {
            this.renderAssetURL(asset.getLocation(), asset.getURI(), sb);
        }
        catch (IOException e) {
            throw new UndeclaredIOException(e);
        }
        return sb.toString();
    }
}

