/*
 * Decompiled with CFR 0.152.
 */
package juzu.bridge.portlet;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.EventPortlet;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.Portlet;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.ResourceServingPortlet;
import javax.portlet.UnavailableException;
import javax.portlet.WindowState;
import juzu.Consumes;
import juzu.PropertyType;
import juzu.impl.asset.AssetServer;
import juzu.impl.bridge.Bridge;
import juzu.impl.bridge.BridgeConfig;
import juzu.impl.bridge.BridgeContext;
import juzu.impl.bridge.module.ApplicationBridge;
import juzu.impl.bridge.spi.portlet.PortletActionBridge;
import juzu.impl.bridge.spi.portlet.PortletEventBridge;
import juzu.impl.bridge.spi.portlet.PortletResourceBridge;
import juzu.impl.bridge.spi.portlet.PortletViewBridge;
import juzu.impl.common.JUL;
import juzu.impl.common.Logger;
import juzu.impl.common.SimpleMap;
import juzu.impl.common.Tools;
import juzu.impl.fs.spi.ReadFileSystem;
import juzu.impl.fs.spi.disk.DiskFileSystem;
import juzu.impl.fs.spi.war.WarFileSystem;
import juzu.impl.inject.spi.Injector;
import juzu.impl.inject.spi.InjectorProvider;
import juzu.impl.inject.spi.spring.SpringInjector;
import juzu.impl.plugin.asset.AssetPlugin;
import juzu.impl.plugin.controller.ControllerPlugin;
import juzu.impl.plugin.controller.ControllerResolver;
import juzu.impl.request.Method;
import juzu.impl.resource.ResourceResolver;
import juzu.request.Phase;

public class JuzuPortlet
implements Portlet,
ResourceServingPortlet,
EventPortlet {
    public static final PropertyType<PortletMode> PORTLET_MODE = new PropertyType<PortletMode>(){};
    public static final PropertyType<WindowState> WINDOW_STATE = new PropertyType<WindowState>(){};
    private Bridge bridge;
    private PortletContext context;
    private PortletConfig config;
    private boolean initialized = false;

    public void init(final PortletConfig config) throws PortletException {
        BridgeConfig bridgeConfig;
        AssetServer server = (AssetServer)config.getPortletContext().getAttribute("asset.server");
        if (server == null) {
            server = new AssetServer();
            config.getPortletContext().setAttribute("asset.server", (Object)server);
        }
        Logger portletLogger = JUL.getLogger(JuzuPortlet.class.getName() + "." + config.getPortletName());
        try {
            bridgeConfig = new BridgeConfig(portletLogger, (Map<String, String>)new SimpleMap<String, String>(){

                @Override
                protected Iterator<String> keys() {
                    return BridgeConfig.NAMES.iterator();
                }

                @Override
                public String get(Object key) {
                    if ("juzu.app_name".equals(key)) {
                        return JuzuPortlet.this.getApplicationName(config);
                    }
                    if ("juzu.inject".equals(key)) {
                        String inject = config.getInitParameter((String)key);
                        if (inject == null) {
                            inject = config.getPortletContext().getInitParameter((String)key);
                        }
                        return inject;
                    }
                    if (BridgeConfig.NAMES.contains(key)) {
                        return config.getInitParameter((String)key);
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            String msg = "Could not find an application to start";
            if (e instanceof PortletException) {
                String nested = e.getMessage();
                if (nested != null) {
                    msg = msg + ":" + nested;
                }
                throw Tools.initCause(new UnavailableException(msg), e.getCause());
            }
            throw new PortletException(msg, (Throwable)e);
        }
        BridgeContext bridgeContext = new BridgeContext(){
            final ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            final ResourceResolver resolver = new ResourceResolver(){

                public URL resolve(String uri) {
                    try {
                        return JuzuPortlet.this.context.getResource(uri);
                    }
                    catch (MalformedURLException e) {
                        return null;
                    }
                }
            };

            @Override
            public ReadFileSystem<?> getResourcePath() {
                return WarFileSystem.create(JuzuPortlet.this.context, "/WEB-INF/");
            }

            @Override
            public ReadFileSystem<?> getSourcePath() {
                String srcPath = JuzuPortlet.this.context.getInitParameter("juzu.src_path");
                return srcPath != null ? new DiskFileSystem(new File(srcPath)) : WarFileSystem.create(JuzuPortlet.this.context, "/WEB-INF/src/");
            }

            @Override
            public ReadFileSystem<?> getClassPath() {
                return WarFileSystem.create(JuzuPortlet.this.context, "/WEB-INF/classes/");
            }

            @Override
            public ClassLoader getClassLoader() {
                return this.classLoader;
            }

            @Override
            public String getInitParameter(String name) {
                return JuzuPortlet.this.context.getInitParameter(name);
            }

            @Override
            public ResourceResolver getResolver() {
                return this.resolver;
            }

            @Override
            public Object getAttribute(String key) {
                return JuzuPortlet.this.context.getAttribute(key);
            }

            @Override
            public void setAttribute(String key, Object value) {
                JuzuPortlet.this.context.setAttribute(key, value);
            }

            @Override
            public Logger getLogger(String name) {
                return JUL.getLogger(name);
            }
        };
        InjectorProvider injectorProvider = bridgeConfig.injectorProvider;
        if (injectorProvider == null) {
            throw new UnavailableException("No inject implementation selected");
        }
        portletLogger.info("Using inject implementation " + injectorProvider.getValue());
        Injector injector = injectorProvider.get();
        if (injector instanceof SpringInjector) {
            SpringInjector springInjector = (SpringInjector)injector;
            Object parent = config.getPortletContext().getAttribute("org.springframework.web.context.WebApplicationContext.ROOT");
            if (parent != null) {
                springInjector.setParent(parent);
            }
        }
        ApplicationBridge bridge = new ApplicationBridge(bridgeContext, bridgeConfig, server, new ResourceResolver(){

            public URL resolve(String uri) {
                try {
                    return JuzuPortlet.this.context.getResource(uri);
                }
                catch (MalformedURLException e) {
                    return null;
                }
            }
        }, injector);
        this.config = config;
        this.bridge = bridge;
        this.context = config.getPortletContext();
    }

    protected String getApplicationName(PortletConfig config) {
        return config.getInitParameter("juzu.app_name");
    }

    private void rethrow(Throwable e) throws PortletException, IOException {
        if (e instanceof PortletException) {
            throw (PortletException)e;
        }
        if (e instanceof IOException) {
            throw (IOException)e;
        }
        throw new PortletException(e);
    }

    public void processAction(ActionRequest req, ActionResponse resp) throws PortletException, IOException {
        try {
            PortletActionBridge requestBridge = new PortletActionBridge(this.bridge, req, resp, this.config);
            requestBridge.invoke();
            requestBridge.send();
        }
        catch (Throwable e) {
            this.rethrow(e);
        }
    }

    public void processEvent(EventRequest request, EventResponse response) throws PortletException, IOException {
        ControllerResolver<Method> resolver = this.bridge.getApplication().resolveBean(ControllerPlugin.class).getDescriptor().getResolver();
        List<Method> methods = resolver.resolveMethods(Phase.EVENT, null, request.getParameterMap().keySet());
        Method target = null;
        for (Method method : methods) {
            Consumes consumes = method.getMethod().getAnnotation(Consumes.class);
            if (consumes.value().equals("")) {
                target = method;
                continue;
            }
            if (!consumes.value().equals(request.getEvent().getName())) continue;
            target = method;
            break;
        }
        if (target != null) {
            try {
                PortletEventBridge requestBridge = new PortletEventBridge(this.bridge, request, response, this.config, target, request.getParameterMap());
                requestBridge.invoke();
                requestBridge.send();
            }
            catch (Throwable e) {
                this.rethrow(e);
            }
        } else {
            response.setRenderParameters(request);
        }
    }

    public void render(RenderRequest req, RenderResponse resp) throws PortletException, IOException {
        if (!this.initialized) {
            try {
                this.bridge.refresh();
                this.initialized = true;
            }
            catch (Exception e) {
                String msg = "Could not initialize application";
                if (e instanceof PortletException) {
                    String nested = e.getMessage();
                    if (nested != null) {
                        msg = msg + ":" + nested;
                    }
                    throw new PortletException(msg, e.getCause());
                }
                throw new PortletException(msg, (Throwable)e);
            }
        }
        try {
            PortletViewBridge requestBridge = new PortletViewBridge(this.bridge, req, resp, this.config);
            requestBridge.invoke();
            requestBridge.send();
        }
        catch (Throwable e) {
            this.rethrow(e);
        }
    }

    public void serveResource(ResourceRequest req, ResourceResponse resp) throws PortletException, IOException {
        boolean assetRequest;
        if (!this.initialized) {
            try {
                this.bridge.refresh();
                this.initialized = true;
            }
            catch (Exception e) {
                String msg = "Could not initialize application";
                if (e instanceof PortletException) {
                    String nested = e.getMessage();
                    if (nested != null) {
                        msg = msg + ":" + nested;
                    }
                    throw new PortletException(msg, e.getCause());
                }
                throw new PortletException(msg, (Throwable)e);
            }
        }
        if ((assetRequest = "assets".equals(req.getParameter("juzu.request"))) && !this.bridge.getRunMode().isStatic()) {
            InputStream in;
            String contentType;
            String path = req.getResourceID();
            AssetPlugin assetPlugin = (AssetPlugin)this.bridge.getApplication().getPlugin("asset");
            URL url = assetPlugin.getAssetManager().resolveAsset(path);
            if (url != null) {
                contentType = path.endsWith(".css") ? "text/css" : (path.endsWith(".js") ? "text/javascript" : null);
                in = url.openStream();
            } else {
                contentType = null;
                in = null;
            }
            if (in != null) {
                if (contentType != null) {
                    resp.setContentType(contentType);
                }
                Tools.copy(in, resp.getPortletOutputStream());
            } else {
                resp.addProperty("portlet.http-status-code", "404");
            }
        } else {
            try {
                PortletResourceBridge requestBridge = new PortletResourceBridge(this.bridge, req, resp, this.config);
                requestBridge.invoke();
                requestBridge.send();
            }
            catch (Throwable throwable) {
                this.rethrow(throwable);
            }
        }
    }

    public void destroy() {
        Tools.safeClose(this.bridge);
    }
}

