/*
 * Decompiled with CFR 0.152.
 */
package juzu;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import juzu.PropertyMap;
import juzu.PropertyType;
import juzu.io.Streamable;
import juzu.io.Streams;
import juzu.request.Dispatch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Response {
    protected final PropertyMap properties;

    protected Response() {
        this.properties = new PropertyMap();
    }

    protected Response(PropertyMap properties) {
        this.properties = properties;
    }

    public <T> Response with(PropertyType<T> propertyType, T propertyValue) throws NullPointerException {
        if (propertyType == null) {
            throw new NullPointerException("No null property type allowed");
        }
        this.properties.setValue(propertyType, propertyValue);
        return this;
    }

    public <T> Response without(PropertyType<T> propertyType) throws NullPointerException {
        return this.with(propertyType, null);
    }

    public Response with(PropertyType<Boolean> propertyType) throws NullPointerException {
        return this.with(propertyType, true);
    }

    public Response withNo(PropertyType<Boolean> propertyType) throws NullPointerException {
        return this.with(propertyType, false);
    }

    public final PropertyMap getProperties() {
        return this.properties;
    }

    public Response withHeader(String name, String ... value) {
        Iterable<Map.Entry<String, String[]>> values = this.properties.getValues(PropertyType.HEADER);
        if (values != null) {
            for (Map.Entry<String, String[]> header : values) {
                if (!header.getKey().equals(name)) continue;
                header.setValue(value);
                return this;
            }
        }
        this.properties.addValue(PropertyType.HEADER, new AbstractMap.SimpleEntry<String, String[]>(name, value));
        return this;
    }

    public static Redirect redirect(String location) {
        return new Redirect(location);
    }

    public static Status status(int code) {
        return new Status(code);
    }

    public static Status ok() {
        return Response.status(200);
    }

    public static Status notFound() {
        return Response.status(404);
    }

    public static Content ok(InputStream content) {
        return Response.content(200, content);
    }

    public static Content ok(byte[] content) {
        return Response.content(200, content);
    }

    public static Content ok(Readable content) {
        return Response.content(200, content);
    }

    public static Content ok(CharSequence content) {
        return Response.content(200, content);
    }

    public static Content notFound(byte[] content) {
        return Response.content(404, content);
    }

    public static Content notFound(InputStream content) {
        return Response.content(404, content);
    }

    public static Content notFound(Readable content) {
        return Response.content(404, content);
    }

    public static Content notFound(CharSequence content) {
        return Response.content(404, content);
    }

    public static Content content(int code, byte[] content) {
        return Response.content(code, new Streamable.Bytes(content));
    }

    public static Content content(int code, InputStream content) {
        return Response.content(code, new Streamable.InputStream(content));
    }

    public static Content content(int code, Readable content) {
        return Response.content(code, Streams.streamable(content));
    }

    public static Content content(int code, CharSequence content) {
        return Response.content(code, new Streamable.CharSequence(content));
    }

    public static Content content(int code, Streamable content) {
        return new Render(code, content);
    }

    public static Error error(Throwable t) {
        return new Error(t);
    }

    public static Error error(String msg) {
        return new Error(msg);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Error
    extends Response {
        private final List<StackTraceElement> at = Collections.unmodifiableList(Arrays.asList(new Exception().getStackTrace()));
        private final Throwable cause;
        private final String msg;

        public Error(Throwable cause) {
            this(null, cause);
        }

        public Error(String message) {
            this(message, null);
        }

        private Error(String message, Throwable cause) {
            this.cause = cause;
            this.msg = message;
        }

        public List<StackTraceElement> getAt() {
            return this.at;
        }

        public Throwable getCause() {
            return this.cause;
        }

        public String getMessage() {
            return this.msg;
        }

        public String toString() {
            return "Response.Error[" + (this.cause != null ? this.cause.getMessage() : "") + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Render
    extends Content {
        public Render(int status, PropertyMap properties, Streamable streamable) {
            super(status, properties, streamable);
        }

        public Render(int status, Streamable streamable) {
            super(status, streamable);
        }

        public Render(PropertyMap properties, Streamable streamable) {
            super(properties, streamable);
        }

        public Render(Streamable streamable) {
            super(streamable);
        }

        @Override
        public <T> Render with(PropertyType<T> propertyType, T propertyValue) throws NullPointerException {
            return (Render)super.with((PropertyType)propertyType, (Object)propertyValue);
        }

        @Override
        public <T> Render without(PropertyType<T> propertyType) throws NullPointerException {
            return (Render)super.without((PropertyType)propertyType);
        }

        @Override
        public Render with(PropertyType<Boolean> propertyType) throws NullPointerException {
            return (Render)super.with((PropertyType)propertyType);
        }

        @Override
        public Render withNo(PropertyType<Boolean> propertyType) throws NullPointerException {
            return (Render)super.withNo((PropertyType)propertyType);
        }

        @Override
        public Render withMimeType(String mimeType) {
            return (Render)super.withMimeType(mimeType);
        }

        @Override
        public Render withCharset(Charset charset) {
            return (Render)super.withCharset(charset);
        }

        @Override
        public Render withHeader(String name, String ... value) {
            return (Render)super.withHeader(name, value);
        }

        @Override
        public Render withTitle(String title) {
            return (Render)super.withTitle(title);
        }

        @Override
        public Render withScripts(String ... scripts) throws NullPointerException {
            return (Render)super.withScripts(scripts);
        }

        @Override
        public Render withStylesheets(String ... stylesheets) throws NullPointerException {
            return (Render)super.withStylesheets(stylesheets);
        }

        @Override
        public Render withMetaTag(String name, String value) {
            return (Render)super.withMetaTag(name, value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Content
    extends Body {
        @Override
        public <T> Content with(PropertyType<T> propertyType, T propertyValue) throws NullPointerException {
            return (Content)super.with((PropertyType)propertyType, (Object)propertyValue);
        }

        @Override
        public <T> Content without(PropertyType<T> propertyType) throws NullPointerException {
            return (Content)super.without((PropertyType)propertyType);
        }

        @Override
        public Content with(PropertyType<Boolean> propertyType) throws NullPointerException {
            return (Content)super.with((PropertyType)propertyType);
        }

        @Override
        public Content withNo(PropertyType<Boolean> propertyType) throws NullPointerException {
            return (Content)super.withNo((PropertyType)propertyType);
        }

        @Override
        public Content withMimeType(String mimeType) {
            return (Content)super.withMimeType(mimeType);
        }

        @Override
        public Content withCharset(Charset charset) {
            return (Content)super.withCharset(charset);
        }

        public Content(int status, PropertyMap properties, Streamable streamable) {
            super(status, properties, streamable);
        }

        public Content(int status, Streamable streamable) {
            super(status, streamable);
        }

        public Content(PropertyMap properties, Streamable streamable) {
            super(200, properties, streamable);
        }

        public Content(Streamable streamable) {
            super(200, streamable);
        }

        @Override
        public Content withHeader(String name, String ... value) {
            return (Render)super.withHeader(name, value);
        }

        public String getTitle() {
            return this.properties.getValue(PropertyType.TITLE);
        }

        public Content withTitle(String title) {
            this.properties.setValue(PropertyType.TITLE, title);
            return this;
        }

        public Content withScripts(String ... scripts) throws NullPointerException {
            if (scripts == null) {
                throw new NullPointerException("No null script accepted");
            }
            this.properties.addValues(PropertyType.SCRIPT, scripts);
            return this;
        }

        public Content withStylesheets(String ... stylesheets) throws NullPointerException {
            if (stylesheets == null) {
                throw new NullPointerException("No null stylesheet accepted");
            }
            this.properties.addValues(PropertyType.STYLESHEET, stylesheets);
            return this;
        }

        public Content withMetaTag(String name, String value) {
            Iterable<Map.Entry<String, String>> values = this.properties.getValues(PropertyType.META_TAG);
            if (values != null) {
                for (Map.Entry<String, String> meta : values) {
                    if (!meta.getKey().equals(name)) continue;
                    meta.setValue(value);
                    return this;
                }
            }
            this.properties.addValue(PropertyType.META_TAG, new AbstractMap.SimpleEntry<String, String>(name, value));
            return this;
        }

        public String toString() {
            return "Response.Content[]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Body
    extends Status {
        private Streamable streamable;

        protected Body(int status, PropertyMap properties) {
            super(status, properties);
            this.streamable = null;
        }

        protected Body(int status, Streamable streamable) {
            super(status);
            this.streamable = streamable;
        }

        protected Body(int status, PropertyMap properties, Streamable streamable) {
            super(status, properties);
            this.streamable = streamable;
        }

        public Streamable getStreamable() {
            return this.streamable;
        }

        public String getMimeType() {
            return this.properties.getValue(PropertyType.MIME_TYPE);
        }

        public Charset getCharset() {
            return this.properties.getValue(PropertyType.CHARSET);
        }

        public Body withCharset(Charset charset) {
            this.properties.setValue(PropertyType.CHARSET, charset);
            return this;
        }

        public Body withMimeType(String mimeType) {
            this.properties.setValue(PropertyType.MIME_TYPE, mimeType);
            return this;
        }

        @Override
        public Body withHeader(String name, String ... value) {
            return (Body)super.withHeader(name, value);
        }

        @Override
        public <T> Body with(PropertyType<T> propertyType, T propertyValue) throws NullPointerException {
            return (Body)super.with(propertyType, propertyValue);
        }

        @Override
        public <T> Body without(PropertyType<T> propertyType) throws NullPointerException {
            return (Body)super.without(propertyType);
        }

        @Override
        public Body with(PropertyType<Boolean> propertyType) throws NullPointerException {
            return (Body)super.with(propertyType);
        }

        @Override
        public Body withNo(PropertyType<Boolean> propertyType) throws NullPointerException {
            return (Body)super.withNo(propertyType);
        }
    }

    public static class Status
    extends Response {
        private int code;

        public Status(int code) {
            this.code = code;
        }

        public Status(int code, PropertyMap properties) {
            super(properties);
            this.code = code;
        }

        public final int getCode() {
            return this.code;
        }

        public Body body(Streamable s) {
            return new Body(this.code, this.properties, s);
        }

        public Body body(CharSequence s) {
            return this.body(new Streamable.CharSequence(s));
        }

        public Body body(byte[] s) {
            return this.body(new Streamable.Bytes(s));
        }

        public Body body(InputStream s) {
            return this.body(new Streamable.InputStream(s));
        }

        public Content content(Streamable s) {
            return new Content(this.code, this.properties, s);
        }

        public Content content(CharSequence s) {
            return this.content(new Streamable.CharSequence(s));
        }

        public Content content(byte[] s) {
            return this.content(new Streamable.Bytes(s));
        }

        public Content content(InputStream s) {
            return this.content(new Streamable.InputStream(s));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Redirect
    extends Response {
        private final String location;

        public Redirect(String location) {
            this.location = location;
        }

        public String getLocation() {
            return this.location;
        }

        @Override
        public <T> Redirect with(PropertyType<T> propertyType, T propertyValue) throws NullPointerException {
            return (Redirect)super.with(propertyType, propertyValue);
        }

        @Override
        public Redirect withHeader(String name, String ... value) {
            return (Redirect)super.withHeader(name, value);
        }

        @Override
        public <T> Redirect without(PropertyType<T> propertyType) throws NullPointerException {
            return (Redirect)super.without(propertyType);
        }

        @Override
        public Redirect with(PropertyType<Boolean> propertyType) throws NullPointerException {
            return (Redirect)super.with(propertyType);
        }

        @Override
        public Redirect withNo(PropertyType<Boolean> propertyType) throws NullPointerException {
            return (Redirect)super.withNo(propertyType);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Redirect) {
                Redirect that = (Redirect)obj;
                return this.location.equals(that.location);
            }
            return false;
        }

        public String toString() {
            return "Response.Redirect[location" + this.location + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class View
    extends Response
    implements Dispatch {
        @Override
        public <T> View with(PropertyType<T> propertyType, T propertyValue) throws NullPointerException {
            return (View)super.with(propertyType, propertyValue);
        }

        @Override
        public View withHeader(String name, String ... value) {
            return (View)super.withHeader(name, value);
        }

        @Override
        public <T> View without(PropertyType<T> propertyType) throws NullPointerException {
            return (View)super.without(propertyType);
        }

        @Override
        public View with(PropertyType<Boolean> propertyType) throws NullPointerException {
            return (View)super.with(propertyType);
        }

        @Override
        public View withNo(PropertyType<Boolean> propertyType) throws NullPointerException {
            return (View)super.withNo(propertyType);
        }

        public abstract boolean equals(Object var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Action
    extends Response {
        public abstract Map<String, String[]> getParameters();
    }
}

