/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.common;

import java.io.IOException;
import java.math.BigInteger;
import java.nio.charset.CharacterCodingException;
import juzu.impl.common.Tools;
import juzu.io.UndeclaredIOException;

public class PercentCodec
extends BigInteger {
    public static final PercentCodec RFC3986_GEN_DELIMS;
    public static final PercentCodec RFC3986_SUB_DELIMS;
    public static final PercentCodec RFC3986_RESERVED_;
    public static final PercentCodec RFC3986_UNRESERVED;
    public static final PercentCodec RFC3986_PCHAR;
    public static final PercentCodec RFC3986_SEGMENT;
    public static final PercentCodec RFC3986_PATH;
    public static final PercentCodec RFC3986_QUERY;
    public static final PercentCodec RFC3986_QUERY_PARAM_NAME;
    public static final PercentCodec RFC3986_QUERY_PARAM_VALUE;
    public static final char[] ALPHABET;

    public static PercentCodec create(BigInteger bitSet) {
        if (bitSet instanceof PercentCodec) {
            return (PercentCodec)bitSet;
        }
        return new PercentCodec(bitSet);
    }

    private PercentCodec(BigInteger val) {
        super(val.toByteArray());
    }

    public boolean accept(char c) {
        return this.testBit(c);
    }

    public void encode(CharSequence s, Appendable appendable) throws IOException {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            this.encode(c, appendable);
        }
    }

    public String encode(CharSequence s) {
        try {
            StringBuilder sb = new StringBuilder(s.length());
            this.encode(s, (Appendable)sb);
            return sb.toString();
        }
        catch (IOException e) {
            throw new UndeclaredIOException(e);
        }
    }

    public void encode(char c, Appendable appendable) throws IOException {
        if (c < '\u0080') {
            if (this.testBit(c)) {
                appendable.append(c);
            } else {
                appendable.append('%');
                appendable.append(ALPHABET[(c & 0xF0) >> 4]);
                appendable.append(ALPHABET[c & 0xF]);
            }
        } else if (c < '\u0800') {
            int c0 = 0x80 | c & 0x3F;
            int c1 = 0xC0 | (c & 0x7C0) >> 6;
            appendable.append('%');
            appendable.append(ALPHABET[(c1 & 0xF0) >> 4]);
            appendable.append(ALPHABET[c1 & 0xF]);
            appendable.append('%');
            appendable.append(ALPHABET[(c0 & 0xF0) >> 4]);
            appendable.append(ALPHABET[c0 & 0xF]);
        } else if (c < '\u10000') {
            int c0 = 0x80 | c & 0x3F;
            int c1 = 0x80 | (c & 0xFC0) >> 6;
            int c2 = 0xE0 | (c & 0xF000) >> 12;
            appendable.append('%');
            appendable.append(ALPHABET[(c2 & 0xF0) >> 4]);
            appendable.append(ALPHABET[c2 & 0xF]);
            appendable.append('%');
            appendable.append(ALPHABET[(c1 & 0xF0) >> 4]);
            appendable.append(ALPHABET[c1 & 0xF]);
            appendable.append('%');
            appendable.append(ALPHABET[(c0 & 0xF0) >> 4]);
            appendable.append(ALPHABET[c0 & 0xF]);
        } else {
            throw new CharacterCodingException();
        }
    }

    public String safeDecode(CharSequence s) throws UndeclaredIOException {
        try {
            return this.decode(s);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public String decode(CharSequence s) throws IllegalArgumentException, UndeclaredIOException {
        try {
            StringBuilder sb = new StringBuilder(s.length());
            this.decode(s, sb);
            return sb.toString();
        }
        catch (IOException e) {
            throw new UndeclaredIOException(e);
        }
    }

    public void decode(CharSequence s, Appendable appendable) throws IllegalArgumentException, IOException {
        this.decode(s, 0, s.length(), appendable);
    }

    public void decode(CharSequence s, int from, int len, Appendable to) throws IllegalArgumentException, IOException {
        while (len > 0) {
            int delta = this.decodeChar(s, from, len, to);
            len -= delta;
            from += delta;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int decodeChar(CharSequence s, int from, int len, Appendable to) throws IllegalArgumentException, IOException {
        char c;
        int prev = len--;
        if ((c = s.charAt(from++)) == '%') {
            char c1;
            if (len < 3) {
                throw new IllegalArgumentException();
            }
            len -= 3;
            if (((c1 = (char)((this.hex(s.charAt(from++)) << 4) + this.hex(s.charAt(from++)))) & 0x80) == 0) {
                to.append(c1);
                return prev - len;
            } else {
                if (len < 3) {
                    throw new IllegalArgumentException();
                }
                if (s.charAt(from++) != '%') {
                    throw new IllegalArgumentException();
                }
                len -= 3;
                char c2 = (char)((this.hex(s.charAt(from++)) << 4) + this.hex(s.charAt(from++)));
                if ((c1 & 0xE0) == 192) {
                    to.append((char)(((c1 & 0x1F) << 6) + (c2 & 0x3F)));
                    return prev - len;
                } else {
                    if (len < 3) {
                        throw new IllegalArgumentException();
                    }
                    if (s.charAt(from++) != '%') {
                        throw new IllegalArgumentException();
                    }
                    len -= 3;
                    char c3 = (char)((this.hex(s.charAt(from++)) << 4) + this.hex(s.charAt(from++)));
                    if ((c1 & 0xF0) != 224) throw new IllegalArgumentException();
                    to.append((char)(((c1 & 0xF) << 12) + ((c2 & 0x3F) << 6) + (c3 & 0x3F)));
                }
            }
            return prev - len;
        } else {
            if (!this.accept(c)) throw new IllegalArgumentException("Illegal char " + c);
            to.append(c);
        }
        return prev - len;
    }

    private int hex(char c) throws IOException {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'A' && c <= 'F') {
            return c + 10 - 65;
        }
        if (c >= 'a' && c <= 'f') {
            return c + 10 - 97;
        }
        throw new IllegalArgumentException();
    }

    static {
        char c;
        RFC3986_GEN_DELIMS = PercentCodec.create(Tools.bitSet(":/?#[]&"));
        RFC3986_SUB_DELIMS = PercentCodec.create(Tools.bitSet("!$&'()*+,;="));
        RFC3986_RESERVED_ = PercentCodec.create(RFC3986_GEN_DELIMS.or(RFC3986_SUB_DELIMS));
        StringBuilder sb = new StringBuilder();
        for (c = 'A'; c <= 'Z'; c = (char)(c + '\u0001')) {
            sb.append(c);
        }
        for (c = 'a'; c <= 'z'; c = (char)(c + '\u0001')) {
            sb.append(c);
        }
        for (c = '0'; c <= '9'; c = (char)(c + '\u0001')) {
            sb.append(c);
        }
        sb.append("_.-~");
        RFC3986_UNRESERVED = PercentCodec.create(Tools.bitSet(sb));
        RFC3986_PCHAR = PercentCodec.create(RFC3986_UNRESERVED.or(RFC3986_SUB_DELIMS).or(Tools.bitSet(":@")));
        RFC3986_SEGMENT = PercentCodec.create(RFC3986_PCHAR);
        RFC3986_PATH = PercentCodec.create(RFC3986_SEGMENT.or(Tools.bitSet("/")));
        RFC3986_QUERY = PercentCodec.create(RFC3986_PCHAR.or(Tools.bitSet("/?")));
        RFC3986_QUERY_PARAM_NAME = PercentCodec.create(RFC3986_QUERY.clearBit(61));
        RFC3986_QUERY_PARAM_VALUE = PercentCodec.create(RFC3986_QUERY.clearBit(38));
        ALPHABET = "0123456789ABCDEF".toCharArray();
    }
}

