/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.inject.spi.spring;

import java.util.Set;
import javax.inject.Singleton;
import juzu.Scope;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.AnnotationScopeMetadataResolver;
import org.springframework.context.annotation.ScopeMetadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScopeMetadataResolverImpl
extends AnnotationScopeMetadataResolver {
    private final Set<Scope> scopes;

    public ScopeMetadataResolverImpl(Set<Scope> scopes) {
        this.scopes = scopes;
    }

    public ScopeMetadata resolveScopeMetadata(BeanDefinition definition) {
        ScopeMetadata metadata = new ScopeMetadata();
        if (definition instanceof AnnotatedBeanDefinition) {
            String scopeName;
            AnnotatedBeanDefinition annDef = (AnnotatedBeanDefinition)definition;
            Set annotationTypes = annDef.getMetadata().getAnnotationTypes();
            if (annotationTypes.contains(Singleton.class.getName())) {
                scopeName = "singleton";
            } else {
                scopeName = "prototype";
                for (Scope scope : this.scopes) {
                    if (!annotationTypes.contains(scope.getAnnotationType().getName())) continue;
                    scopeName = scope.name().toLowerCase();
                    break;
                }
            }
            metadata.setScopeName(scopeName);
            return metadata;
        }
        return super.resolveScopeMetadata(definition);
    }
}

