/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.plugin.module;

import java.io.File;
import java.net.URL;
import juzu.impl.common.JSON;
import juzu.impl.common.Logger;
import juzu.impl.common.RunMode;
import juzu.impl.common.Tools;
import juzu.impl.fs.spi.ReadFileSystem;
import juzu.impl.fs.spi.disk.DiskFileSystem;
import juzu.impl.fs.spi.war.WarFileSystem;
import juzu.impl.plugin.module.ModuleContext;
import juzu.impl.plugin.module.ModuleLifeCycle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractWarModuleContext
implements ModuleContext {
    private final Logger log;
    private WarFileSystem resourcePath;
    private ModuleLifeCycle<?> lifeCycle;
    private RunMode runMode;

    protected AbstractWarModuleContext(Logger log) {
        this.log = log;
    }

    @Override
    public JSON getConfig() throws Exception {
        URL cfg = this.getClassLoader().getResource("juzu/config.json");
        String s = Tools.read(cfg);
        return (JSON)JSON.parse(s);
    }

    protected abstract WarFileSystem createFileSystem(String var1);

    protected abstract String getInitParameter(String var1);

    @Override
    public ReadFileSystem<?> getResourcePath() {
        if (this.resourcePath == null) {
            this.resourcePath = this.createFileSystem("/WEB-INF/");
        }
        return this.resourcePath;
    }

    @Override
    public RunMode getRunMode() {
        if (this.runMode == null) {
            String runModeValue = this.getInitParameter("juzu.run_mode");
            if (runModeValue != null) {
                this.runMode = RunMode.parse(runModeValue);
                if (this.runMode == null) {
                    this.log.log("Unparseable run mode " + runModeValue + " will use prod instead");
                    this.runMode = RunMode.PROD;
                }
            } else {
                this.runMode = RunMode.PROD;
            }
        }
        return this.runMode;
    }

    @Override
    public ModuleLifeCycle<?> getLifeCycle() {
        if (this.lifeCycle == null) {
            String srcPath = this.getInitParameter("juzu.src_path");
            ReadFileSystem sourcePath = srcPath != null ? new DiskFileSystem(new File(srcPath)) : this.createFileSystem("/WEB-INF/src/");
            RunMode runMode = this.getRunMode();
            this.lifeCycle = runMode.isDynamic() ? new ModuleLifeCycle.Dynamic<File>(this.log, Thread.currentThread().getContextClassLoader(), sourcePath) : new ModuleLifeCycle.Static<String>(this.log, Thread.currentThread().getContextClassLoader(), this.createFileSystem("/WEB-INF/classes/"));
        }
        return this.lifeCycle;
    }
}

