/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.bridge.spi.portlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import javax.portlet.MimeResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import juzu.Response;
import juzu.impl.bridge.Bridge;
import juzu.impl.bridge.spi.MimeBridge;
import juzu.impl.bridge.spi.portlet.PortletRequestBridge;
import juzu.impl.common.Formatting;
import juzu.io.Stream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PortletMimeBridge<Rq extends PortletRequest, Rs extends MimeResponse>
extends PortletRequestBridge<Rq, Rs>
implements MimeBridge {
    PortletMimeBridge(Bridge bridge, Rq request, Rs response, PortletConfig config) {
        super(bridge, request, response, config);
    }

    public abstract Stream createStream(String var1, Charset var2) throws IOException;

    @Override
    public void send() throws IOException, PortletException {
        if (this.response instanceof Response.Status) {
            Response.Status status = (Response.Status)this.response;
            if (status.getCode() != 200) {
                ((MimeResponse)this.resp).addProperty("portlet.http-status-code", Integer.toString(status.getCode()));
            }
            this.sendProperties();
            if (status instanceof Response.Body) {
                Response.Body body = (Response.Body)this.response;
                Stream stream = this.createStream(body.getMimeType(), body.getCharset());
                body.getStreamable().send(stream);
            }
        } else if (this.response instanceof Response.Error) {
            Response.Error error = (Response.Error)this.response;
            if (this.bridge.module.context.getRunMode().getPrettyFail()) {
                ((MimeResponse)this.resp).setContentType("text/html");
                PrintWriter writer = ((MimeResponse)this.resp).getWriter();
                writer.append("<div class=\"juzu\">");
                Throwable cause = error.getCause();
                if (cause != null) {
                    Formatting.renderThrowable(null, writer, cause);
                } else {
                    writer.append(error.getMessage());
                }
                writer.append("</div>");
                writer.close();
            } else {
                throw new PortletException(error.getCause());
            }
        }
    }
}

