/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.fs.spi.ram;

import java.util.Arrays;
import juzu.impl.fs.spi.ram.RAMDir;
import juzu.impl.fs.spi.ram.RAMFileSystem;

abstract class RAMPath {
    private static final String[] EMPTY = new String[0];
    final RAMFileSystem fs;
    final String name;
    final String[] names;
    RAMDir parent;

    RAMPath(RAMFileSystem fs) {
        this.fs = fs;
        this.name = "";
        this.parent = null;
        this.names = EMPTY;
    }

    RAMPath(RAMDir parent, String name) {
        if (parent == null) {
            throw new NullPointerException();
        }
        if (name == null) {
            throw new NullPointerException();
        }
        if (name.length() == 0) {
            throw new IllegalArgumentException();
        }
        String[] names = Arrays.copyOf(parent.names, parent.names.length + 1);
        names[names.length - 1] = name;
        this.fs = parent.fs;
        this.name = name;
        this.parent = parent;
        this.names = names;
    }

    abstract long getLastModified();

    abstract void touch();

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.name + "]";
    }
}

