/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.plugin.router;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import juzu.impl.common.JSON;
import juzu.impl.plugin.PluginDescriptor;
import juzu.impl.plugin.router.ParamDescriptor;
import juzu.impl.router.PathParam;
import juzu.impl.router.Route;
import juzu.impl.router.Router;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RouteDescriptor
extends PluginDescriptor {
    private final String path;
    private final Map<String, String> targets;
    private final List<RouteDescriptor> children;
    private final HashMap<String, ParamDescriptor> parameters;

    public RouteDescriptor(JSON json) {
        JSON targets = json.getJSON("targets");
        if (targets != null) {
            Set<String> names = targets.names();
            if (names.size() > 0) {
                this.targets = new HashMap<String, String>();
                for (String name : names) {
                    String value = targets.getString(name);
                    this.targets.put(name, value);
                }
            } else {
                this.targets = Collections.emptyMap();
            }
        } else {
            this.targets = Collections.emptyMap();
        }
        List abc = Collections.emptyList();
        List<JSON> children = json.getList("routes", JSON.class);
        if (children != null) {
            for (JSON child : children) {
                RouteDescriptor c = new RouteDescriptor(child);
                if (abc.isEmpty()) {
                    abc = new LinkedList();
                }
                abc.add(c);
            }
        }
        HashMap<String, ParamDescriptor> parameters = null;
        JSON foo = json.getJSON("parameters");
        if (foo != null) {
            parameters = new HashMap<String, ParamDescriptor>();
            for (String name : foo.names()) {
                String pattern = foo.getJSON(name).getString("pattern");
                Boolean preservePath = foo.getJSON(name).getBoolean("preserve-path");
                Boolean captureGroup = foo.getJSON(name).getBoolean("capture-group");
                parameters.put(name, new ParamDescriptor(pattern, preservePath, captureGroup));
            }
        }
        this.children = abc;
        this.path = json.getString("path");
        this.parameters = parameters;
    }

    public String getPath() {
        return this.path;
    }

    public Map<String, String> getTargets() {
        return this.targets;
    }

    public List<RouteDescriptor> getChildren() {
        return this.children;
    }

    public HashMap<String, ParamDescriptor> getParameters() {
        return this.parameters;
    }

    public Map<RouteDescriptor, Route> create() {
        LinkedHashMap<RouteDescriptor, Route> ret = new LinkedHashMap<RouteDescriptor, Route>();
        Router router = new Router();
        ret.put(this, router);
        this.populateChildren(router, ret);
        return ret;
    }

    public Map<RouteDescriptor, Route> popupate(Route parent) {
        LinkedHashMap<RouteDescriptor, Route> ret = new LinkedHashMap<RouteDescriptor, Route>();
        this.popupate(parent, ret);
        return ret;
    }

    public void popupate(Route parent, Map<RouteDescriptor, Route> ret) {
        Map<String, PathParam.Builder> parameters;
        if (this.parameters != null && this.parameters.size() > 0) {
            parameters = new HashMap<String, PathParam.Builder>(this.parameters.size());
            for (Map.Entry<String, ParamDescriptor> parameter : this.parameters.entrySet()) {
                ParamDescriptor paramDescriptor = parameter.getValue();
                PathParam.Builder builder = PathParam.matching(paramDescriptor.pattern);
                if (paramDescriptor.preservePath != null) {
                    builder.setPreservePath(paramDescriptor.preservePath);
                }
                if (paramDescriptor.captureGroup != null) {
                    builder.setCaptureGroup(paramDescriptor.captureGroup);
                }
                parameters.put(parameter.getKey(), builder);
            }
        } else {
            parameters = Collections.emptyMap();
        }
        Route route = parent.append(this.path, parameters);
        ret.put(this, route);
        this.populateChildren(route, ret);
    }

    private void populateChildren(Route route, Map<RouteDescriptor, Route> ret) {
        for (RouteDescriptor child : this.children) {
            child.popupate(route, ret);
        }
    }
}

