/*
 * Decompiled with CFR 0.152.
 */
package juzu.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import juzu.io.Stream;

public abstract class BinaryStream
implements Stream {
    public static final int BUFFER_SIZE = 512;
    private Charset charset;
    private CharsetEncoder encoder;
    private ByteBuffer bb;
    private CharBuffer single;

    protected BinaryStream(Charset charset) {
        this.charset = charset;
    }

    public Stream append(CharBuffer buffer) throws IOException {
        block7: {
            if (buffer.hasRemaining()) {
                CoderResult result;
                if (this.encoder == null) {
                    this.encoder = this.charset.newEncoder().onUnmappableCharacter(CodingErrorAction.REPORT).onMalformedInput(CodingErrorAction.IGNORE);
                    this.bb = ByteBuffer.allocate(512);
                } else {
                    this.encoder.reset();
                }
                while (true) {
                    CoderResult coderResult = result = buffer.hasRemaining() ? this.encoder.encode(buffer, this.bb, true) : this.encoder.flush(this.bb);
                    if (result.isUnderflow() || result.isOverflow()) {
                        this.bb.flip();
                        if (this.bb.hasRemaining()) {
                            this.append(this.bb);
                        }
                        this.bb.clear();
                        if (!result.isUnderflow()) continue;
                        if (buffer.remaining() > 0) {
                            throw new UnsupportedOperationException("We don't support this case yet");
                        }
                        break block7;
                    }
                    if (!result.isUnmappable()) break;
                    buffer.position(buffer.position() + result.length());
                }
                throw new UnsupportedOperationException("We don't support this case yet (2) " + result);
            }
        }
        return this;
    }

    public abstract BinaryStream append(byte[] var1, int var2, int var3) throws IOException;

    public abstract BinaryStream append(byte[] var1) throws IOException;

    public Stream append(ByteBuffer buffer) throws IOException {
        this.append(this.bb.array(), this.bb.arrayOffset() + this.bb.position(), this.bb.limit() - this.bb.arrayOffset());
        return this;
    }

    public Stream append(CharSequence csq) throws IOException {
        return this.append(csq, 0, csq.length());
    }

    public Stream append(CharSequence csq, int start, int end) throws IOException {
        return this.append(CharBuffer.wrap(csq, start, end));
    }

    public Stream append(char c) throws IOException {
        if (this.single == null) {
            this.single = CharBuffer.allocate(1);
        } else {
            this.single.compact();
        }
        this.single.put(c);
        this.single.flip();
        return this.append(this.single);
    }
}

