/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.bridge.spi.web;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import juzu.PropertyMap;
import juzu.PropertyType;
import juzu.Response;
import juzu.impl.asset.Asset;
import juzu.impl.bridge.Bridge;
import juzu.impl.bridge.spi.DispatchBridge;
import juzu.impl.bridge.spi.RequestBridge;
import juzu.impl.bridge.spi.ScopedContext;
import juzu.impl.bridge.spi.web.Handler;
import juzu.impl.bridge.spi.web.WebBridge;
import juzu.impl.bridge.spi.web.WebRenderBridge;
import juzu.impl.common.MethodHandle;
import juzu.impl.common.MimeType;
import juzu.impl.common.Tools;
import juzu.impl.common.UriBuilder;
import juzu.impl.inject.Scoped;
import juzu.impl.plugin.controller.ControllerPlugin;
import juzu.impl.request.ControlParameter;
import juzu.impl.request.Method;
import juzu.impl.request.Request;
import juzu.impl.router.PathParam;
import juzu.impl.router.Route;
import juzu.impl.router.RouteMatch;
import juzu.request.ApplicationContext;
import juzu.request.HttpContext;
import juzu.request.Phase;
import juzu.request.RequestParameter;
import juzu.request.ResponseParameter;
import juzu.request.SecurityContext;
import juzu.request.UserContext;
import juzu.request.WindowContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WebRequestBridge
implements RequestBridge,
WindowContext {
    final Bridge bridge;
    final Handler handler;
    final WebBridge http;
    final Method<?> target;
    final Map<ControlParameter, Object> arguments;
    protected Request request;
    protected UserContext userContext;
    protected Map<String, RequestParameter> requestParameters;
    protected Response response;

    WebRequestBridge(Bridge bridge, Handler handler, WebBridge http, Method<?> target, Map<String, RequestParameter> requestParameters) {
        this.arguments = target.getArguments(requestParameters);
        this.requestParameters = requestParameters;
        this.bridge = bridge;
        this.target = target;
        this.handler = handler;
        this.http = http;
        this.request = null;
    }

    @Override
    public Map<String, RequestParameter> getRequestParameters() {
        return this.requestParameters;
    }

    @Override
    public MethodHandle getTarget() {
        return this.target.getHandle();
    }

    @Override
    public Map<ControlParameter, Object> getArguments() {
        return this.arguments;
    }

    @Override
    public <T> T getProperty(PropertyType<T> propertyType) {
        if (PropertyType.PATH.equals(propertyType)) {
            return propertyType.cast(this.http.getRequestContext().getRequestURI());
        }
        return null;
    }

    @Override
    public final String getNamespace() {
        return "window_ns";
    }

    @Override
    public final String getId() {
        return "window_id";
    }

    @Override
    public final HttpContext getHttpContext() {
        return this.http.getHttpContext();
    }

    @Override
    public final WindowContext getWindowContext() {
        return this;
    }

    @Override
    public final SecurityContext getSecurityContext() {
        return null;
    }

    @Override
    public UserContext getUserContext() {
        return this.http.getUserContext();
    }

    @Override
    public ApplicationContext getApplicationContext() {
        return this.http.getApplicationContext();
    }

    @Override
    public final Scoped getRequestValue(Object key) {
        ScopedContext context = this.http.getRequestScope(false);
        return context != null ? context.get(key) : null;
    }

    @Override
    public final void setRequestValue(Object key, Scoped value) {
        if (value != null) {
            ScopedContext context = this.http.getRequestScope(false);
            if (context != null) {
                context.set(key, null);
            }
        } else {
            this.http.getRequestScope(true).set(key, value);
        }
    }

    @Override
    public final Scoped getFlashValue(Object key) {
        ScopedContext context = this.http.getFlashScope(false);
        return context != null ? context.get(key) : null;
    }

    @Override
    public final void setFlashValue(Object key, Scoped value) {
        if (value == null) {
            ScopedContext context = this.http.getFlashScope(false);
            if (context != null) {
                context.set(key, null);
            }
        } else {
            this.http.getFlashScope(true).set(key, value);
        }
    }

    @Override
    public final Scoped getSessionValue(Object key) {
        ScopedContext context = this.http.getSessionScope(false);
        return context != null ? context.get(key) : null;
    }

    @Override
    public final void setSessionValue(Object key, Scoped value) {
        if (value == null) {
            ScopedContext context = this.http.getSessionScope(false);
            if (context != null) {
                context.set(key, null);
            }
        } else {
            this.http.getSessionScope(true).set(key, value);
        }
    }

    @Override
    public final Scoped getIdentityValue(Object key) {
        return null;
    }

    @Override
    public final void setIdentityValue(Object key, Scoped value) {
    }

    @Override
    public void purgeSession() {
        this.http.purgeSession();
    }

    @Override
    public final DispatchBridge createDispatch(Phase phase, final MethodHandle target, final Map<String, ResponseParameter> parameters) {
        Method method = this.bridge.application.resolveBean(ControllerPlugin.class).getDescriptor().getMethodByHandle(target);
        Route route = this.handler.getRoute(method.getHandle());
        if (route == null && this.bridge.application.resolveBean(ControllerPlugin.class).getResolver().isIndex(method)) {
            route = this.handler.getRoot();
        }
        if (route != null) {
            Map<String, String> params;
            if (parameters.isEmpty()) {
                params = Collections.emptyMap();
            } else {
                params = new HashMap<String, String>(parameters.size());
                for (ResponseParameter parameter : parameters.values()) {
                    params.put(parameter.getName(), parameter.get(0));
                }
            }
            final RouteMatch match = route.matches(params);
            if (match != null) {
                return new DispatchBridge(){

                    @Override
                    public MethodHandle getTarget() {
                        return target;
                    }

                    @Override
                    public Map<String, ResponseParameter> getParameters() {
                        return parameters;
                    }

                    @Override
                    public <T> String checkPropertyValidity(PropertyType<T> propertyType, T propertyValue) {
                        return null;
                    }

                    @Override
                    public void renderURL(PropertyMap properties, MimeType mimeType, Appendable appendable) throws IOException {
                        WebRequestBridge.this.http.renderRequestURL(appendable);
                        UriBuilder writer = new UriBuilder(appendable, mimeType);
                        match.render(writer);
                        HashSet<String> matched = match.getMatched().isEmpty() ? Collections.emptySet() : new HashSet<String>(match.getMatched().size());
                        for (PathParam param : match.getMatched().keySet()) {
                            matched.add(param.getName());
                        }
                        for (ResponseParameter parameter : parameters.values()) {
                            if (matched.contains(parameter.getName())) continue;
                            for (int i = 0; i < parameter.size(); ++i) {
                                writer.appendQueryParameter(parameter.getEncoding(), parameter.getName(), parameter.get(i));
                            }
                        }
                    }
                };
            }
            throw new IllegalArgumentException("The parameters " + parameters + " are not valid");
        }
        throw new UnsupportedOperationException("handle me gracefully method not mapped " + method.getHandle());
    }

    @Override
    public void setResponse(Response response) throws IllegalArgumentException, IOException {
        this.response = response;
    }

    @Override
    public final void begin(Request request) {
        this.request = request;
    }

    @Override
    public void end() {
        this.request = null;
        ScopedContext context = this.http.getRequestScope(false);
        if (context != null) {
            context.close();
        }
    }

    @Override
    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void invoke() throws Exception {
        try {
            this.bridge.application.resolveBean(ControllerPlugin.class).invoke(this);
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            Tools.safeClose(this);
            throw throwable;
        }
        Tools.safeClose(this);
    }

    boolean send() throws Exception {
        if (this.response instanceof Response.Error) {
            Response.Error error = (Response.Error)this.response;
            this.http.getRequestContext().send(error, this.bridge.module.context.getRunMode().getPrettyFail());
            return true;
        }
        if (this.response instanceof Response.View) {
            Phase.View.Dispatch update = (Phase.View.Dispatch)this.response;
            Boolean redirect = this.response.getProperties().getValue(PropertyType.REDIRECT_AFTER_ACTION);
            if (redirect != null && !redirect.booleanValue()) {
                Method desc = this.bridge.application.resolveBean(ControllerPlugin.class).getDescriptor().getMethodByHandle(update.getTarget());
                Map<String, RequestParameter> rp = Collections.emptyMap();
                for (ResponseParameter parameter : update.getParameters().values()) {
                    if (rp.isEmpty()) {
                        rp = new HashMap();
                    }
                    RequestParameter requestParameter = RequestParameter.create(parameter.getName(), parameter.toArray());
                    rp.put(requestParameter.getName(), requestParameter);
                }
                WebRenderBridge requestBridge = new WebRenderBridge(this.bridge, this.handler, this.http, desc, rp);
                requestBridge.invoke();
                return requestBridge.send();
            }
            String url = update.with(MimeType.PLAIN).with(update.getProperties()).toString();
            Iterable<Map.Entry<String, Object>> headers = this.response.getProperties().getValues(PropertyType.HEADER);
            if (headers == null) {
                headers = Tools.emptyIterable();
            }
            this.http.getRequestContext().setHeaders(headers);
            this.http.getRequestContext().sendRedirect(url);
            return true;
        }
        if (this.response instanceof Response.Redirect) {
            Response.Redirect redirect = (Response.Redirect)this.response;
            String url = redirect.getLocation();
            this.http.getRequestContext().sendRedirect(url);
            return true;
        }
        return false;
    }

    private String getAssetURL(Asset asset) throws IOException {
        StringBuilder url = new StringBuilder();
        String uri = asset.getURI();
        this.http.getRequestContext().renderAssetURL(asset.getLocation(), uri, url);
        return url.toString();
    }
}

