/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.inject.spi;

import java.io.Closeable;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import juzu.impl.inject.ScopeController;
import juzu.impl.inject.spi.BeanLifeCycle;
import juzu.impl.inject.spi.InjectorProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class InjectionContext<B, I>
implements Closeable {
    public abstract ScopeController getScopeController();

    public abstract InjectorProvider getProvider();

    public abstract ClassLoader getClassLoader();

    public abstract B resolveBean(Class<?> var1);

    public abstract B resolveBean(String var1);

    public abstract Iterable<B> resolveBeans(Class<?> var1);

    public abstract I create(B var1) throws InvocationTargetException;

    public abstract Object get(B var1, I var2) throws InvocationTargetException;

    public abstract void release(B var1, I var2);

    @Override
    public abstract void close();

    public final <T> BeanLifeCycle<T> get(Class<T> type) {
        B a = this.resolveBean(type);
        if (a == null) {
            return null;
        }
        return new BeanLifeCycleImpl(type, this, a);
    }

    public final <T> Iterable<BeanLifeCycle<T>> resolve(final Class<T> type) {
        final Iterable<B> a = this.resolveBeans(type);
        return new Iterable<BeanLifeCycle<T>>(){

            @Override
            public Iterator<BeanLifeCycle<T>> iterator() {
                return new Iterator<BeanLifeCycle<T>>(){
                    final Iterator<B> i;
                    {
                        this.i = a.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }

                    @Override
                    public BeanLifeCycle<T> next() {
                        Object b = this.i.next();
                        return new BeanLifeCycleImpl(type, InjectionContext.this, b);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BeanLifeCycleImpl<B, I, T>
    implements BeanLifeCycle<T> {
        final Class<T> type;
        final InjectionContext<B, I> manager;
        final B a;
        private I instance;
        private T o;

        private BeanLifeCycleImpl(Class<T> type, InjectionContext<B, I> manager, B a) {
            this.type = type;
            this.manager = manager;
            this.a = a;
        }

        @Override
        public T get() throws InvocationTargetException {
            if (this.o == null) {
                this.instance = this.manager.create(this.a);
                this.o = this.type.cast(this.manager.get(this.a, this.instance));
            }
            return this.o;
        }

        @Override
        public T peek() {
            return this.o;
        }

        @Override
        public void close() {
            if (this.instance != null) {
                this.manager.release(this.a, this.instance);
            }
        }
    }
}

