/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.inject.spi.cdi;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Provider;
import juzu.Scope;
import juzu.impl.common.Filter;
import juzu.impl.fs.spi.ReadFileSystem;
import juzu.impl.inject.ScopeController;
import juzu.impl.inject.spi.InjectionContext;
import juzu.impl.inject.spi.Injector;
import juzu.impl.inject.spi.cdi.AbstractBean;
import juzu.impl.inject.spi.cdi.CDIContext;
import juzu.impl.inject.spi.cdi.DeclaredBean;
import juzu.impl.inject.spi.cdi.DeclaredProviderBean;
import juzu.impl.inject.spi.cdi.SingletonBean;
import juzu.impl.inject.spi.cdi.SingletonProviderBean;
import juzu.impl.inject.spi.cdi.weld.WeldContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDIInjector
extends Injector {
    private Set<Scope> scopes;
    private ClassLoader classLoader;
    private List<ReadFileSystem<?>> fileSystems;
    private ArrayList<AbstractBean> boundBeans;
    private final ScopeController scopeController;

    public CDIInjector() {
        this.scopes = new HashSet<Scope>();
        this.classLoader = null;
        this.fileSystems = new ArrayList();
        this.boundBeans = new ArrayList();
        this.scopeController = new ScopeController();
    }

    public CDIInjector(CDIInjector that) {
        this.scopes = new HashSet<Scope>(that.scopes);
        this.classLoader = that.classLoader;
        this.fileSystems = new ArrayList(that.fileSystems);
        this.boundBeans = new ArrayList<AbstractBean>(that.boundBeans);
        this.scopeController = that.scopeController;
    }

    @Override
    public <T> Injector declareBean(Class<T> type, Scope beanScope, Iterable<Annotation> qualifiers, Class<? extends T> implementationType) {
        this.boundBeans.add(new DeclaredBean(implementationType != null ? implementationType : type, beanScope, qualifiers));
        return this;
    }

    @Override
    public <T> Injector declareProvider(Class<T> type, Scope beanScope, Iterable<Annotation> qualifiers, Class<? extends Provider<T>> provider) {
        this.boundBeans.add(new DeclaredProviderBean(type, beanScope, qualifiers, provider));
        return this;
    }

    @Override
    public <P> Injector addFileSystem(ReadFileSystem<P> fs) {
        this.fileSystems.add(fs);
        return this;
    }

    @Override
    public Injector addScope(Scope scope) {
        this.scopes.add(scope);
        return this;
    }

    @Override
    public Injector setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }

    @Override
    public <T> Injector bindBean(Class<T> type, Iterable<Annotation> qualifiers, T instance) {
        this.boundBeans.add(new SingletonBean(type, qualifiers, instance));
        return this;
    }

    @Override
    public <T> Injector bindProvider(Class<T> beanType, Scope beanScope, Iterable<Annotation> beanQualifiers, Provider<? extends T> provider) {
        this.boundBeans.add(new SingletonProviderBean(beanType, beanScope, beanQualifiers, provider));
        return this;
    }

    @Override
    public InjectionContext<?, ?> create(Filter<Class<?>> filter) throws Exception {
        WeldContainer container = new WeldContainer(this.classLoader, this.scopeController, this.scopes);
        for (ReadFileSystem<?> fs : this.fileSystems) {
            container.addFileSystem(fs);
        }
        return new CDIContext(this.scopeController, container, filter, this.boundBeans);
    }

    @Override
    public Injector get() {
        return new CDIInjector(this);
    }
}

