/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.plugin.binding;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import javax.inject.Provider;
import juzu.Scope;
import juzu.impl.common.JSON;
import juzu.impl.common.Tools;
import juzu.impl.inject.BeanDescriptor;
import juzu.impl.plugin.PluginContext;
import juzu.impl.plugin.PluginDescriptor;
import juzu.impl.plugin.application.ApplicationPlugin;
import juzu.impl.plugin.binding.BindingDescriptor;
import juzu.inject.ProviderFactory;

public class BindingPlugin
extends ApplicationPlugin {
    public BindingPlugin() {
        super("binding");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PluginDescriptor init(PluginContext context) throws Exception {
        JSON config = context.getConfig();
        ClassLoader loader = context.getClassLoader();
        if (config == null) return null;
        ArrayList<ProviderFactory> factories = Tools.list(ServiceLoader.load(ProviderFactory.class, loader));
        ArrayList<BeanDescriptor> beans = new ArrayList<BeanDescriptor>();
        List<JSON> bindings = config.getList("bindings", JSON.class);
        for (JSON binding : bindings) {
            BeanDescriptor descriptor;
            Class<?> beanImplClass;
            String value = binding.getString("value");
            String scope = binding.getString("scope");
            String implementation = binding.getString("implementation");
            Class<?> beanClass = loader.loadClass(value);
            Scope beanScope = scope != null ? Scope.valueOf(scope.toUpperCase()) : null;
            Class<?> clazz = beanImplClass = implementation != null ? loader.loadClass(implementation) : null;
            if (beanImplClass != null) {
                if (Provider.class.isAssignableFrom(beanImplClass)) {
                    descriptor = BeanDescriptor.createFromProviderType(beanClass, beanScope, null, beanImplClass);
                } else {
                    if (!beanClass.isAssignableFrom(beanImplClass)) throw new UnsupportedClassVersionError("Handle me gracefully / not tested");
                    descriptor = BeanDescriptor.createFromImpl(beanClass, beanScope, null, beanImplClass);
                }
            } else {
                descriptor = null;
                for (ProviderFactory factory : factories) {
                    Provider<?> provider = factory.getProvider(beanClass);
                    if (provider == null) continue;
                    descriptor = BeanDescriptor.createFromProvider(beanClass, beanScope, null, provider);
                }
                if (descriptor == null) {
                    if (beanClass.isInterface()) {
                        throw new UnsupportedClassVersionError("Handle me gracefully / not tested");
                    }
                    if (beanClass.isEnum()) {
                        throw new UnsupportedClassVersionError("Handle me gracefully / not tested");
                    }
                    if (beanClass.isPrimitive()) {
                        throw new UnsupportedClassVersionError("Handle me gracefully / not tested");
                    }
                    if (Modifier.isAbstract(beanClass.getModifiers())) {
                        throw new UnsupportedClassVersionError("Handle me gracefully / not tested");
                    }
                    descriptor = BeanDescriptor.createFromBean(beanClass, beanScope, null);
                }
            }
            beans.add(descriptor);
        }
        return new BindingDescriptor(beans);
    }
}

