/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.bridge.spi.servlet;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.AsyncContext;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpUtils;
import juzu.asset.AssetLocation;
import juzu.impl.bridge.spi.web.WebRequestContext;
import juzu.impl.common.Lexers;
import juzu.io.BinaryOutputStream;
import juzu.io.Stream;
import juzu.request.RequestParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletRequestContext
extends WebRequestContext {
    final HttpServletRequest req;
    final HttpServletResponse resp;
    final String path;
    final String requestPath;
    final Map<String, RequestParameter> requestParameters;

    public ServletRequestContext(HttpServletRequest req, HttpServletResponse resp, String path) {
        Map requestParameters = Collections.emptyMap();
        String query = req.getQueryString();
        if (query != null) {
            Iterator<RequestParameter> i = Lexers.queryParser(query);
            while (i.hasNext()) {
                if (requestParameters.isEmpty()) {
                    requestParameters = new HashMap();
                }
                RequestParameter requestParameter = i.next();
                requestParameter.appendTo(requestParameters);
            }
        }
        if ("POST".equals(req.getMethod()) && "application/x-www-form-urlencoded".equals(req.getContentType())) {
            try {
                for (Map.Entry<String, String[]> entry : HttpUtils.parsePostData((int)req.getContentLength(), (ServletInputStream)req.getInputStream()).entrySet()) {
                    RequestParameter requestParameter;
                    if (requestParameters.isEmpty()) {
                        requestParameters = new HashMap();
                    }
                    requestParameter = (requestParameter = (RequestParameter)requestParameters.get(entry.getKey())) != null ? requestParameter.append(entry.getValue()) : RequestParameter.create(entry);
                    requestParameter.appendTo(requestParameters);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.requestPath = req.getRequestURI().substring(req.getContextPath().length());
        this.requestParameters = requestParameters;
        this.req = req;
        this.path = path;
        this.resp = resp;
    }

    @Override
    public Map<String, RequestParameter> getParameters() {
        return this.requestParameters;
    }

    @Override
    public String getRequestPath() {
        return this.requestPath;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getRequestURI() {
        return this.req.getRequestURI();
    }

    @Override
    public Stream getStream(Charset charset) throws IOException {
        return new StreamImpl(charset, this.resp.getOutputStream());
    }

    @Override
    protected void end(Stream stream) {
        ((StreamImpl)stream).end();
    }

    @Override
    public void setHeaders(Iterable<Map.Entry<String, String[]>> headers) {
        for (Map.Entry<String, String[]> header : headers) {
            this.resp.setHeader(header.getKey(), header.getValue()[0]);
        }
    }

    public void setHeaders(String name, String value) {
        this.resp.setHeader(name, value);
    }

    @Override
    public void sendRedirect(String location) throws IOException {
        this.resp.sendRedirect(location);
    }

    @Override
    public void setContentType(String mimeType, Charset charset) {
        this.resp.setCharacterEncoding(charset.name());
        this.resp.setContentType(mimeType);
    }

    @Override
    public void setStatus(int status) {
        this.resp.setStatus(status);
    }

    @Override
    public void renderAssetURL(AssetLocation location, String uri, Appendable appendable) throws IOException {
        switch (location) {
            case SERVER: {
                if (!uri.startsWith("/")) {
                    appendable.append(this.req.getContextPath());
                    appendable.append('/');
                }
                appendable.append(uri);
                break;
            }
            case APPLICATION: {
                appendable.append(this.req.getContextPath()).append("/assets");
                appendable.append(uri);
                break;
            }
            case URL: {
                appendable.append(uri);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    class StreamImpl
    extends BinaryOutputStream {
        private boolean closed;
        private AsyncContext context;

        StreamImpl(Charset charset, ServletOutputStream out) {
            super(charset, (OutputStream)out);
        }

        public void close() throws IOException {
            this.closed = true;
            if (this.context != null) {
                System.out.println("COMPLETING ASYNC");
                this.context.complete();
            }
        }

        void end() {
            if (ServletRequestContext.this.req.isAsyncStarted()) {
                System.out.println("DETECTED ASYNC ALREADY STARTED");
                this.context = ServletRequestContext.this.req.getAsyncContext();
            } else if (!this.closed) {
                System.out.println("STARTING ASYNC");
                this.context = ServletRequestContext.this.req.startAsync();
            }
        }
    }
}

