/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.bridge.module;

import juzu.impl.asset.AssetServer;
import juzu.impl.bridge.Bridge;
import juzu.impl.bridge.BridgeConfig;
import juzu.impl.bridge.BridgeContext;
import juzu.impl.bridge.module.ModuleContextImpl;
import juzu.impl.common.Logger;
import juzu.impl.common.RunMode;
import juzu.impl.common.Tools;
import juzu.impl.inject.spi.Injector;
import juzu.impl.plugin.application.Application;
import juzu.impl.resource.ResourceResolver;
import juzu.impl.runtime.ApplicationRuntime;

public class ApplicationBridge
extends Bridge {
    private ModuleContextImpl module;
    private ApplicationRuntime<?, ?> application;
    private final Injector injector;
    private RunMode runMode;
    private final Logger log;

    public ApplicationBridge(BridgeContext context, BridgeConfig config, AssetServer server, ResourceResolver resolver, Injector injector) {
        super(context, config, server, resolver);
        this.log = context.getLogger(ApplicationBridge.class.getName());
        this.injector = injector;
    }

    public RunMode getRunMode() {
        if (this.runMode == null) {
            String runModeValue = this.context.getInitParameter("juzu.run_mode");
            if (runModeValue != null) {
                runModeValue = Tools.interpolate(runModeValue, System.getProperties());
                this.runMode = RunMode.parse(runModeValue);
                if (this.runMode == null) {
                    this.log.info("Unparseable run mode " + runModeValue + " will use prod instead");
                    this.runMode = RunMode.PROD;
                }
            } else {
                this.runMode = RunMode.PROD;
            }
        }
        return this.runMode;
    }

    public boolean refresh(boolean recompile) throws Exception {
        if (this.module == null) {
            this.module = (ModuleContextImpl)this.context.getAttribute("juzu.module");
            if (this.module == null) {
                this.module = new ModuleContextImpl(this.log, this, this.context, this.resolver);
                this.context.setAttribute("juzu.module", this.module);
                this.module.runtime.refresh(true);
            }
            this.module.lease();
        }
        this.module.runtime.refresh(recompile);
        if (this.application == null) {
            this.application = new ApplicationRuntime(this.log, this.module.runtime, this.injector, this.config.name, this.server, this.resolver);
        }
        return this.application.refresh();
    }

    public Application getApplication() {
        return this.application.getApplication();
    }

    public void close() {
        Tools.safeClose(this.application);
    }
}

