/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.common;

import java.io.Serializable;
import java.util.EnumMap;
import javax.tools.JavaFileObject;
import juzu.impl.common.Path;
import juzu.impl.common.Tools;

public class FileKey
implements Serializable {
    private static final EnumMap<JavaFileObject.Kind, String> KIND_TO_EXT = new EnumMap(JavaFileObject.Kind.class);
    public final Iterable<String> packageNames;
    public final Iterable<String> names;
    public final String packageFQN;
    public final String rawName;
    public final String fqn;
    public final String name;
    public final String ext;

    public static FileKey newResourceName(String packageName, String name) {
        FileKey key = FileKey.newName(packageName, name);
        if (key.getKind() == JavaFileObject.Kind.OTHER) {
            return key;
        }
        throw new IllegalArgumentException();
    }

    public static FileKey newResourceName(String packageName, String rawName, String ext) {
        FileKey key = FileKey.newName(packageName, rawName, ext);
        if (key.getKind() == JavaFileObject.Kind.OTHER) {
            return key;
        }
        throw new IllegalArgumentException();
    }

    public static FileKey newJavaName(String className, JavaFileObject.Kind kind) {
        if (kind == JavaFileObject.Kind.SOURCE || kind == JavaFileObject.Kind.CLASS) {
            int pos = className.lastIndexOf(46);
            if (pos == -1) {
                return new FileKey("", className, KIND_TO_EXT.get((Object)kind));
            }
            return new FileKey(className.substring(0, pos), className.substring(pos + 1), KIND_TO_EXT.get((Object)kind));
        }
        throw new IllegalArgumentException("Kind " + (Object)((Object)kind) + " not accepted");
    }

    public static FileKey newJavaName(String packageName, String name) {
        String ext;
        if (name.endsWith(".java")) {
            ext = "java";
        } else if (name.endsWith(".class")) {
            ext = "class";
        } else {
            throw new IllegalArgumentException("Illegal name " + name);
        }
        String rawName = name.substring(0, name.length() - 1 - ext.length());
        return new FileKey(packageName, rawName, ext);
    }

    public static FileKey newName(String packageName, String name) {
        String ext;
        String rawName;
        int pos = name.indexOf(46);
        if (pos == -1) {
            rawName = name;
            ext = "";
        } else {
            rawName = name.substring(0, pos);
            ext = name.substring(pos + 1);
        }
        return FileKey.newName(packageName, rawName, ext);
    }

    public static FileKey newName(String packageName, String rawName, String ext) {
        return new FileKey(packageName, rawName, ext);
    }

    public static FileKey newName(Path.Absolute path) {
        return new FileKey(path.getDirs().toString(), path.getRawName(), path.getExt());
    }

    private FileKey(String packageFQN, String rawName, String ext) {
        String name = rawName + "." + ext;
        String fqn = packageFQN.length() == 0 ? rawName : packageFQN + "." + rawName;
        String[] abc = Tools.split(packageFQN, '.', 1);
        abc[abc.length - 1] = name;
        this.packageNames = Tools.iterable(abc, 0, abc.length - 1);
        this.names = Tools.iterable(abc, 0, abc.length);
        this.packageFQN = packageFQN;
        this.rawName = rawName;
        this.fqn = fqn;
        this.ext = ext;
        this.name = name;
    }

    public FileKey as(JavaFileObject.Kind kind) {
        return new FileKey(this.packageFQN, this.rawName, kind.extension.substring(1));
    }

    public JavaFileObject.Kind getKind() {
        if (this.ext.equals("java")) {
            return JavaFileObject.Kind.SOURCE;
        }
        if (this.ext.equals("class")) {
            return JavaFileObject.Kind.CLASS;
        }
        return JavaFileObject.Kind.OTHER;
    }

    public final int hashCode() {
        return this.packageFQN.hashCode() ^ this.rawName.hashCode() ^ this.ext.hashCode();
    }

    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof FileKey) {
            FileKey that = (FileKey)obj;
            return this.packageFQN.equals(that.packageFQN) && this.rawName.equals(that.rawName) && this.ext.equals(that.ext);
        }
        return false;
    }

    public String toString() {
        return "FileKey[packageName=" + this.packageFQN + ",rawName=" + this.rawName + ",ext=" + this.ext + "]";
    }

    static {
        KIND_TO_EXT.put(JavaFileObject.Kind.CLASS, "class");
        KIND_TO_EXT.put(JavaFileObject.Kind.SOURCE, "java");
    }
}

