/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.router;

import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import juzu.impl.common.Tools;
import juzu.impl.common.UriBuilder;
import juzu.impl.router.EmptyRoute;
import juzu.impl.router.MalformedRouteException;
import juzu.impl.router.Path;
import juzu.impl.router.PathParam;
import juzu.impl.router.PatternBuilder;
import juzu.impl.router.PatternRoute;
import juzu.impl.router.RERef;
import juzu.impl.router.RouteKind;
import juzu.impl.router.RouteMatch;
import juzu.impl.router.Router;
import juzu.impl.router.SegmentRoute;
import juzu.impl.router.parser.RouteParser;
import juzu.impl.router.parser.RouteParserHandler;
import juzu.impl.router.regex.RE;
import juzu.impl.router.regex.SyntaxException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Route {
    static final int TERMINATION_NONE = 0;
    static final int TERMINATION_SEGMENT = 1;
    static final int TERMINATION_SEPARATOR = 2;
    static final int TERMINATION_ANY = 3;
    private static final Route[] EMPTY_ROUTE_ARRAY = new Route[0];
    private final Router router;
    private final int terminal;
    private Route parent;
    private List<Route> path;
    private Route[] children;

    void writeTo(XMLStreamWriter writer) throws XMLStreamException {
        if (this instanceof SegmentRoute) {
            writer.writeStartElement("segment");
            writer.writeAttribute("path", "/" + ((SegmentRoute)this).name);
            writer.writeAttribute("terminal", "" + this.terminal);
        } else if (this instanceof PatternRoute) {
            PatternRoute pr = (PatternRoute)this;
            StringBuilder path = new StringBuilder("/");
            for (int i = 0; i < pr.params.length; ++i) {
                path.append(pr.chunks[i]).append("{").append(pr.params[i].name).append("}");
            }
            path.append(pr.chunks[pr.chunks.length - 1]);
            writer.writeStartElement("pattern");
            writer.writeAttribute("path", path.toString());
            writer.writeAttribute("terminal", Integer.toString(this.terminal));
            for (PathParam param : pr.params) {
                writer.writeStartElement("path-param");
                writer.writeAttribute("qname", param.name);
                writer.writeAttribute("preservePath", "" + param.preservePath);
                writer.writeAttribute("pattern", param.matchingRegex.toString());
                writer.writeEndElement();
            }
        } else {
            writer.writeStartElement("route");
        }
        writer.writeEndElement();
    }

    public String toString() {
        try {
            XMLOutputFactory factory = XMLOutputFactory.newInstance();
            StringWriter sw = new StringWriter();
            XMLStreamWriter xmlWriter = factory.createXMLStreamWriter(sw);
            this.writeTo(xmlWriter);
            return sw.toString();
        }
        catch (XMLStreamException e) {
            throw new AssertionError((Object)e);
        }
    }

    Route(Router router, int terminal) {
        if (router == null) {
            router = (Router)this;
        }
        this.router = router;
        this.path = Collections.singletonList(this);
        this.parent = null;
        this.terminal = terminal;
        this.children = EMPTY_ROUTE_ARRAY;
    }

    public final void clearChildren() {
        this.children = EMPTY_ROUTE_ARRAY;
    }

    public final Route getParent() {
        return this.parent;
    }

    public final List<Route> getPath() {
        return this.path;
    }

    final boolean renderPath(RouteMatch match, UriBuilder writer, boolean hasChildren) throws IOException {
        boolean endWithSlash;
        boolean bl = endWithSlash = this.parent != null && this.parent.renderPath(match, writer, true);
        if (this instanceof SegmentRoute) {
            SegmentRoute sr = (SegmentRoute)this;
            if (!endWithSlash) {
                writer.append('/');
            }
            String name = sr.encodedName;
            writer.append(name);
            endWithSlash = false;
        } else if (this instanceof EmptyRoute) {
            if (!endWithSlash) {
                writer.append('/');
                endWithSlash = true;
            }
        } else if (this instanceof PatternRoute) {
            int i;
            PatternRoute pr = (PatternRoute)this;
            if (!endWithSlash) {
                writer.append('/');
                endWithSlash = true;
            }
            int count = 0;
            for (i = 0; i < pr.params.length; ++i) {
                writer.append(pr.encodedChunks[i]);
                count += pr.chunks[i].length();
                PathParam def = pr.params[i];
                String value = match.matched.get(def);
                count += value.length();
                int len = value.length();
                for (int j = 0; j < len; ++j) {
                    char c = value.charAt(j);
                    if (c == this.router.separatorEscape) {
                        if (def.preservePath) {
                            writer.append('_');
                            continue;
                        }
                        writer.append('%');
                        writer.append(this.router.separatorEscapeNible1);
                        writer.append(this.router.separatorEscapeNible2);
                        continue;
                    }
                    if (c == '/') {
                        writer.append(def.preservePath ? (char)'/' : this.router.separatorEscape);
                        continue;
                    }
                    writer.appendSegment(c);
                }
            }
            writer.append(pr.encodedChunks[i]);
            if ((count += pr.chunks[i].length()) > 0) {
                endWithSlash = false;
            }
        } else if (!hasChildren) {
            writer.append('/');
            endWithSlash = true;
        }
        return endWithSlash;
    }

    public final RouteMatch matches(Map<String, String> parameters) {
        HashMap<String, String> unmatched = new HashMap<String, String>(parameters);
        HashMap<PathParam, String> matched = new HashMap<PathParam, String>();
        if (this._matches(unmatched, matched)) {
            return new RouteMatch(this, unmatched, matched);
        }
        return null;
    }

    private boolean _matches(HashMap<String, String> context, HashMap<PathParam, String> matched) {
        return (this.parent == null || this.parent._matches(context, matched)) && this.matches(context, matched);
    }

    private boolean matches(HashMap<String, String> context, HashMap<PathParam, String> abc) {
        if (this instanceof PatternRoute) {
            PatternRoute prt = (PatternRoute)this;
            for (int i = 0; i < prt.params.length; ++i) {
                PathParam param = prt.params[i];
                String s = context.get(param.name);
                String matched = null;
                if (s != null) {
                    for (int j = 0; j < param.matchingRegex.length; ++j) {
                        RERef renderingRegex = param.matchingRegex[j];
                        if (!renderingRegex.re.matcher().matches(s)) continue;
                        matched = param.templatePrefixes[j] + s + param.templateSuffixes[j];
                        break;
                    }
                }
                if (matched == null) {
                    return false;
                }
                context.remove(param.name);
                abc.put(param, matched);
            }
        }
        return true;
    }

    public final RouteMatch route(String path) {
        return this.route(path, Collections.<String, String[]>emptyMap());
    }

    public final RouteMatch route(String path, Map<String, String[]> queryParams) {
        Iterator<RouteMatch> matcher = this.matcher(path, queryParams);
        return matcher.hasNext() ? matcher.next() : null;
    }

    public final Iterator<RouteMatch> matcher(String path, Map<String, String[]> requestParams) {
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        return new RouteMatcher(this, Path.parse(path), requestParams);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static RouteFrame route(RouteFrame root, Map<String, String[]> requestParams) {
        RouteFrame routeFrame = root;
        if (root.status == RouteFrame.Status.MATCHED) {
            if (root.parent == null) return null;
            RouteFrame routeFrame2 = root.parent;
        } else if (root.status != RouteFrame.Status.BEGIN) {
            throw new AssertionError((Object)("Unexpected status " + (Object)((Object)root.status)));
        }
        while (true) {
            void var2_4;
            block32: {
                void var4_24;
                block35: {
                    block33: {
                        int pos;
                        block34: {
                            if (((RouteFrame)var2_4).status == RouteFrame.Status.BEGIN) {
                                ((RouteFrame)var2_4).status = RouteFrame.Status.PROCESS_CHILDREN;
                                continue;
                            }
                            if (((RouteFrame)var2_4).status == RouteFrame.Status.PROCESS_CHILDREN) {
                                if (((RouteFrame)var2_4).childIndex < ((RouteFrame)var2_4).route.children.length) {
                                    void var4_17;
                                    Route child = ((RouteFrame)var2_4).route.children[((RouteFrame)var2_4).childIndex++];
                                    if (child instanceof EmptyRoute) {
                                        RouteFrame routeFrame3 = new RouteFrame((RouteFrame)var2_4, child, ((RouteFrame)var2_4).path);
                                    } else if (child instanceof SegmentRoute) {
                                        String segment;
                                        int POS;
                                        SegmentRoute segmentRoute = (SegmentRoute)child;
                                        for (POS = 0; POS < ((RouteFrame)var2_4).path.length() && ((RouteFrame)var2_4).path.charAt(POS) == '/'; ++POS) {
                                        }
                                        int pos2 = ((RouteFrame)var2_4).path.indexOf(47, POS);
                                        if (pos2 == -1) {
                                            pos2 = ((RouteFrame)var2_4).path.length();
                                        }
                                        if (segmentRoute.name.equals(segment = ((RouteFrame)var2_4).path.getValue().substring(POS, pos2))) {
                                            Path nextSegmentPath = ((RouteFrame)var2_4).path.subPath(pos2);
                                            RouteFrame routeFrame4 = new RouteFrame((RouteFrame)var2_4, segmentRoute, nextSegmentPath);
                                        } else {
                                            Object var4_12 = null;
                                        }
                                    } else {
                                        RE.Match[] matches;
                                        if (!(child instanceof PatternRoute)) throw new AssertionError();
                                        PatternRoute patternRoute = (PatternRoute)child;
                                        Path path = ((RouteFrame)var2_4).path;
                                        if (path.length() > 0 && path.charAt(0) == '/') {
                                            path = path.subPath(1);
                                        }
                                        if ((matches = patternRoute.pattern.re.matcher().find(path.getValue())).length > 0) {
                                            int nextPos = matches[0].getEnd();
                                            Path nextPath = path.subPath(nextPos);
                                            RouteFrame routeFrame5 = new RouteFrame((RouteFrame)var2_4, patternRoute, nextPath);
                                            int index = 1;
                                            for (int i = 0; i < patternRoute.params.length; ++i) {
                                                PathParam param = patternRoute.params[i];
                                                for (int j = 0; j < param.matchingRegex.length; ++j) {
                                                    String value;
                                                    RE.Match match = matches[index + j];
                                                    if (match.getEnd() == -1) continue;
                                                    if (!param.preservePath) {
                                                        StringBuilder sb = new StringBuilder();
                                                        for (int from = match.getStart(); from < match.getEnd(); ++from) {
                                                            char c = path.charAt(from);
                                                            if (c == child.router.separatorEscape && !path.isEscaped(from)) {
                                                                c = '/';
                                                            }
                                                            sb.append(c);
                                                        }
                                                        value = sb.toString();
                                                    } else {
                                                        value = match.getValue();
                                                    }
                                                    if (routeFrame5.matches == null) {
                                                        routeFrame5.matches = new HashMap();
                                                    }
                                                    routeFrame5.matches.put(param, value);
                                                    break;
                                                }
                                                index += param.matchingRegex.length;
                                            }
                                        } else {
                                            Object var4_15 = null;
                                        }
                                    }
                                    if (var4_17 == null) continue;
                                    void var2_5 = var4_17;
                                    continue;
                                }
                                ((RouteFrame)var2_4).status = RouteFrame.Status.DO_CHECK;
                                continue;
                            }
                            if (((RouteFrame)var2_4).status != RouteFrame.Status.DO_CHECK) break block32;
                            for (pos = 0; pos < ((RouteFrame)var2_4).path.length() && ((RouteFrame)var2_4).path.charAt(pos) == '/'; ++pos) {
                            }
                            if (pos != ((RouteFrame)var2_4).path.length()) break block33;
                            if (!(((RouteFrame)var2_4).route instanceof EmptyRoute)) break block34;
                            RouteFrame.Status status = RouteFrame.Status.MATCHED;
                            break block35;
                        }
                        switch (((RouteFrame)var2_4).route.terminal) {
                            case 0: {
                                RouteFrame.Status status = RouteFrame.Status.END;
                                break block35;
                            }
                            case 1: {
                                RouteFrame.Status status = pos == 0 ? RouteFrame.Status.MATCHED : RouteFrame.Status.END;
                                break block35;
                            }
                            case 2: {
                                RouteFrame.Status status = pos == 0 ? RouteFrame.Status.END : RouteFrame.Status.MATCHED;
                                break block35;
                            }
                            case 3: {
                                RouteFrame.Status status = RouteFrame.Status.MATCHED;
                                break block35;
                            }
                            default: {
                                throw new AssertionError();
                            }
                        }
                    }
                    RouteFrame.Status status = RouteFrame.Status.END;
                }
                ((RouteFrame)var2_4).status = (RouteFrame.Status)var4_24;
                continue;
            }
            if (((RouteFrame)var2_4).status == RouteFrame.Status.MATCHED) return var2_4;
            if (((RouteFrame)var2_4).status != RouteFrame.Status.END) throw new AssertionError();
            if (((RouteFrame)var2_4).parent == null) return var2_4;
            RouteFrame routeFrame6 = ((RouteFrame)var2_4).parent;
        }
    }

    private void add(Route route) throws MalformedRouteException {
        if (route == null) {
            throw new NullPointerException("No null route accepted");
        }
        if (route.parent != null) {
            throw new IllegalArgumentException("No route with an existing parent can be accepted");
        }
        LinkedList<PathParam> ancestorParams = new LinkedList<PathParam>();
        this.findAncestorOrSelfParams(ancestorParams);
        LinkedList<PathParam> descendantParams = new LinkedList<PathParam>();
        for (PathParam param : ancestorParams) {
            route.findDescendantOrSelfParams(param.name, descendantParams);
            if (descendantParams.size() <= 0) continue;
            throw new MalformedRouteException("Duplicate parameter " + param.name);
        }
        if (!(route instanceof PatternRoute || route instanceof SegmentRoute || route instanceof EmptyRoute)) {
            throw new IllegalArgumentException("Only accept segment or pattern routes");
        }
        this.children = Tools.appendTo(this.children, route);
        ArrayList<Route> path = new ArrayList<Route>(this.path.size() + 1);
        path.addAll(this.path);
        path.add(route);
        route.parent = this;
        route.path = Collections.unmodifiableList(path);
    }

    final Set<String> getSegmentNames() {
        HashSet<String> names = new HashSet<String>();
        for (Route child : this.children) {
            if (!(child instanceof SegmentRoute)) continue;
            SegmentRoute childSegment = (SegmentRoute)child;
            names.add(childSegment.name);
        }
        return names;
    }

    final int getSegmentSize(String segmentName) {
        int size = 0;
        for (Route child : this.children) {
            if (!(child instanceof SegmentRoute)) continue;
            SegmentRoute childSegment = (SegmentRoute)child;
            if (!segmentName.equals(childSegment.name)) continue;
            ++size;
        }
        return size;
    }

    final SegmentRoute getSegment(String segmentName, int index) {
        for (Route child : this.children) {
            if (!(child instanceof SegmentRoute)) continue;
            SegmentRoute childSegment = (SegmentRoute)child;
            if (!segmentName.equals(childSegment.name)) continue;
            if (index == 0) {
                return childSegment;
            }
            --index;
        }
        return null;
    }

    final int getPatternSize() {
        int size = 0;
        for (Route route : this.children) {
            if (!(route instanceof PatternRoute)) continue;
            ++size;
        }
        return size;
    }

    final PatternRoute getPattern(int index) {
        for (Route route : this.children) {
            if (!(route instanceof PatternRoute)) continue;
            if (index == 0) {
                return (PatternRoute)route;
            }
            --index;
        }
        return null;
    }

    private PathParam getParam(String name) {
        PathParam param = null;
        if (this instanceof PatternRoute) {
            for (PathParam pathParam : ((PatternRoute)this).params) {
                if (!pathParam.name.equals(name)) continue;
                param = pathParam;
                break;
            }
        }
        return param;
    }

    private PathParam findParam(String name) {
        PathParam param = this.getParam(name);
        if (param == null && this.parent != null) {
            param = this.parent.findParam(name);
        }
        return param;
    }

    private void findParams(List<PathParam> params) {
        if (this instanceof PatternRoute) {
            Collections.addAll(params, ((PatternRoute)this).params);
        }
    }

    private void findAncestorOrSelfParams(List<PathParam> params) {
        this.findParams(params);
        if (this.parent != null) {
            this.parent.findAncestorOrSelfParams(params);
        }
    }

    private void findDescendantOrSelfParams(String name, List<PathParam> params) {
        PathParam param = this.getParam(name);
        if (param != null) {
            params.add(param);
        }
    }

    public Route append(String path) {
        return this.append(path, RouteKind.MATCH);
    }

    public Route append(String path, RouteKind kind) {
        return this.append(path, kind, Collections.<String, PathParam.Builder>emptyMap());
    }

    public Route append(String path, Map<String, PathParam.Builder> params) {
        return this.append(path, RouteKind.MATCH, params);
    }

    public Route append(String path, final RouteKind kind, final Map<String, PathParam.Builder> params) throws NullPointerException {
        if (path == null) {
            throw new NullPointerException("No null route path accepted");
        }
        if (kind == null) {
            throw new NullPointerException("No null route kind accepted");
        }
        if (params == null) {
            throw new NullPointerException("No null route params accepted");
        }
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class Assembler
        implements RouteParserHandler {
            LinkedList<Data> datas = new LinkedList();
            Route last = null;

            Assembler() {
            }

            @Override
            public void segmentOpen() {
                this.datas.add(new Data());
            }

            @Override
            public void segmentChunk(CharSequence s, int from, int to) {
                this.datas.peekLast().builder.litteral(s, from, to);
                this.datas.peekLast().chunks.add(s.subSequence(from, to).toString());
                this.datas.peekLast().lastSegment = true;
            }

            @Override
            public void segmentClose() {
                if (!this.datas.peekLast().lastSegment) {
                    this.datas.peekLast().chunks.add("");
                }
            }

            @Override
            public void exprOpen() {
                if (!this.datas.peekLast().lastSegment) {
                    this.datas.peekLast().chunks.add("");
                }
            }

            @Override
            public void exprIdent(CharSequence s, int from, int to) {
                String parameterName;
                this.datas.peekLast().paramName = parameterName = s.subSequence(from, to).toString();
            }

            @Override
            public void exprClose() {
                this.datas.peekLast().lastSegment = false;
                PathParam.Builder desc = (PathParam.Builder)params.get(this.datas.peekLast().paramName);
                if (desc == null) {
                    desc = new PathParam.Builder();
                }
                PathParam param = desc.build(Route.this.router, this.datas.peekLast().paramName);
                this.datas.peekLast().builder.expr("(?:").expr(param.routingRegex).expr(")");
                this.datas.peekLast().parameterPatterns.add(param);
            }

            @Override
            public void pathClose(boolean slash) {
                if (this.datas.isEmpty()) {
                    this.last = new EmptyRoute(Route.this.router, kind.getTerminal(slash));
                    Route.this.add(this.last);
                } else {
                    this.last = Route.this;
                    while (this.datas.size() > 0) {
                        Route next;
                        int terminal;
                        Data data = this.datas.removeFirst();
                        int n = terminal = this.datas.isEmpty() ? kind.getTerminal(slash) : 0;
                        if (data.parameterPatterns.isEmpty()) {
                            next = new SegmentRoute(Route.this.router, data.chunks.get(0), terminal);
                        } else {
                            data.builder.expr("(?:(?<=^)|(?=/)|$)");
                            next = new PatternRoute(Route.this.router, Route.this.router.compile(data.builder.build()), data.parameterPatterns, data.chunks, terminal);
                        }
                        this.last.add(next);
                        this.last = next;
                    }
                }
            }
        }
        Assembler asm = new Assembler();
        try {
            RouteParser.parse(path, asm);
        }
        catch (SyntaxException e) {
            throw new MalformedRouteException(e);
        }
        return asm.last;
    }

    static class Data {
        PatternBuilder builder = new PatternBuilder().expr("");
        List<String> chunks = new ArrayList<String>();
        List<PathParam> parameterPatterns = new ArrayList<PathParam>();
        String paramName = null;
        boolean lastSegment = false;

        Data() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class RouteMatcher
    implements Iterator<RouteMatch> {
        private final Map<String, String[]> requestParams;
        private RouteFrame frame;
        private RouteFrame next;

        RouteMatcher(Route route, Path path, Map<String, String[]> requestParams) {
            this.frame = new RouteFrame(route, path);
            this.requestParams = requestParams;
        }

        @Override
        public boolean hasNext() {
            if (this.next == null) {
                if (this.frame != null) {
                    this.frame = Route.route(this.frame, this.requestParams);
                }
                if (this.frame != null && this.frame.status == RouteFrame.Status.MATCHED) {
                    this.next = this.frame;
                }
            }
            return this.next != null;
        }

        @Override
        public RouteMatch next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Map<PathParam, String> parameters = this.next.getParameters();
            Route route = this.next.route;
            this.next = null;
            return new RouteMatch(route, parameters);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class RouteFrame {
        private final RouteFrame parent;
        private final Route route;
        private final Path path;
        private Status status;
        private Map<PathParam, String> matches;
        private int childIndex;

        private RouteFrame(RouteFrame parent, Route route, Path path) {
            this.parent = parent;
            this.route = route;
            this.path = path;
            this.status = Status.BEGIN;
            this.childIndex = 0;
        }

        private RouteFrame(Route route, Path path) {
            this(null, route, path);
        }

        Map<PathParam, String> getParameters() {
            Map<PathParam, String> parameters = null;
            RouteFrame frame = this;
            while (frame != null) {
                if (frame.matches != null) {
                    if (parameters == null) {
                        parameters = new HashMap<PathParam, String>();
                    }
                    parameters.putAll(frame.matches);
                }
                frame = frame.parent;
            }
            return parameters != null ? parameters : Collections.emptyMap();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static enum Status {
            BEGIN,
            PROCESS_CHILDREN,
            DO_CHECK,
            MATCHED,
            END;

        }
    }
}

