/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.router;

import juzu.impl.router.MalformedRouteException;
import juzu.impl.router.regex.GroupType;
import juzu.impl.router.regex.RENode;
import juzu.impl.router.regex.REVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RouteEscaper
extends REVisitor<MalformedRouteException> {
    private final char src;
    private final char dst;

    RouteEscaper(char src, char dst) {
        this.src = src;
        this.dst = dst;
    }

    @Override
    protected void visit(RENode.Char expr) throws MalformedRouteException {
        if (expr.getValue() == this.src) {
            expr.setValue(this.dst);
        }
    }

    @Override
    protected void visit(RENode.Group expr) throws MalformedRouteException {
        if (expr.getType() == GroupType.CAPTURING_GROUP) {
            expr.setType(GroupType.NON_CAPTURING_GROUP);
        }
        super.visit(expr);
    }

    @Override
    protected void visit(RENode.Any expr) throws MalformedRouteException {
        RENode.CharacterClass repl = new RENode.CharacterClass(new RENode.CharacterClassExpr.Not(new RENode.CharacterClassExpr.Char('/')));
        repl.setQuantifier(expr.getQuantifier());
        expr.replaceBy(repl);
    }

    @Override
    protected void visit(RENode.CharacterClass expr) throws MalformedRouteException {
        RENode.CharacterClassExpr ccExpr = expr.getExpr();
        ccExpr = ccExpr.replace(this.src, this.dst);
    }
}

