/*
 * Copyright 2013 eXo Platform SAS
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package juzu.impl.asset;

import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import java.util.Set;

/** @author Julien Viet */
public class Foo implements ServletContainerInitializer {
  public void onStartup(Set<Class<?>> c, ServletContext ctx) throws ServletException {
    // Bind asset server
    ServletRegistration.Dynamic registration = ctx.addServlet("AssetServlet", AssetServlet.class);
    if (registration != null) {
      registration.addMapping("/assets/*");
    } else {
      // It was already registered by some mean
    }
  }
}
