/*
 * Copyright 2013 eXo Platform SAS
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package juzu.impl.plugin.template;

import juzu.impl.inject.spi.InjectorProvider;
import juzu.template.TemplateExecutionException;
import juzu.test.AbstractInjectTestCase;
import juzu.test.protocol.mock.MockApplication;
import juzu.test.protocol.mock.MockClient;
import juzu.test.protocol.mock.MockViewBridge;
import org.junit.Test;

import javax.naming.AuthenticationException;
import java.util.ConcurrentModificationException;

/** @author <a href="mailto:julien.viet@exoplatform.com">Julien Viet</a> */
public class ThrowableTestCase extends AbstractInjectTestCase {

  public ThrowableTestCase(InjectorProvider di) {
    super(di);
  }

  @Test
  public void testChecked() throws Exception {
    MockApplication<?> app = application("plugin.template.throwable.checked").init();

    //
    MockClient client = app.client();
    MockViewBridge render = client.render();
    TemplateExecutionException te = render.assertFailure(TemplateExecutionException.class);
    assertInstanceOf(AuthenticationException.class, te.getCause());
  }

  @Test
  public void testRuntime() throws Exception {
    MockApplication<?> app = application("plugin.template.throwable.runtime").init();

    //
    MockClient client = app.client();
    MockViewBridge render = client.render();
    TemplateExecutionException te = render.assertFailure(TemplateExecutionException.class);
    assertInstanceOf(ConcurrentModificationException.class, te.getCause());
  }

  @Test
  public void testError() throws Exception {
    MockApplication<?> app = application("plugin.template.throwable.error").init();

    //
    MockClient client = app.client();
    MockViewBridge render = client.render();
    render.assertFailure(UnknownError.class);
  }
}
