/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.metamodel;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.annotation.processing.Completion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.TypeElement;
import juzu.impl.common.Name;
import juzu.impl.compiler.ProcessingContext;
import juzu.impl.compiler.ProcessingException;
import juzu.impl.metamodel.AnnotationChange;
import juzu.impl.metamodel.AnnotationKey;
import juzu.impl.metamodel.AnnotationState;
import juzu.impl.metamodel.EventQueue;
import juzu.impl.metamodel.MetaModel;
import juzu.impl.metamodel.MetaModelPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MetaModelContext<P extends MetaModelPlugin<M, P>, M extends MetaModel<P, M>>
implements Serializable,
Iterable<M> {
    private ProcessingContext processingContext;
    private ArrayList<M> metaModels;
    private LinkedHashMap<String, P> pluginMap;
    private HashMap<P, HashSet<Name>> supportedAnnotationsMap;
    private Set<Class<? extends Annotation>> supportedAnnotations;
    private final Class<P> pluginType;
    final LinkedHashMap<AnnotationKey, AnnotationState> knownAnnotations = new LinkedHashMap();

    public MetaModelContext(Class<P> pluginType) {
        this.pluginType = pluginType;
        this.metaModels = new ArrayList();
    }

    public void init(ProcessingContext env) throws NullPointerException {
        this.processingContext = env;
        HashMap supportedAnnotationsMap = new HashMap();
        LinkedHashMap<String, MetaModelPlugin> pluginMap = new LinkedHashMap<String, MetaModelPlugin>();
        StringBuilder msg = new StringBuilder("Using plugins:");
        for (MetaModelPlugin plugin : env.loadServices(this.pluginType)) {
            msg.append(" ").append(plugin.getName());
            pluginMap.put(plugin.getName(), plugin);
        }
        env.info(msg);
        HashSet<Class<? extends Annotation>> supportedAnnotations = new HashSet<Class<? extends Annotation>>();
        for (MetaModelPlugin plugin : pluginMap.values()) {
            HashSet<Name> pluginSupportedAnnotations = new HashSet<Name>();
            for (Class<Annotation> annotationType : plugin.init(env)) {
                pluginSupportedAnnotations.add(Name.create(annotationType));
                supportedAnnotations.add(annotationType);
            }
            env.info("Plugin " + plugin.getName() + " supports " + pluginSupportedAnnotations);
            supportedAnnotationsMap.put(plugin, pluginSupportedAnnotations);
        }
        this.pluginMap = pluginMap;
        this.supportedAnnotationsMap = supportedAnnotationsMap;
        this.supportedAnnotations = supportedAnnotations;
    }

    @Override
    public Iterator<M> iterator() {
        return this.metaModels.iterator();
    }

    public Set<Class<? extends Annotation>> getSupportedAnnotations() {
        return this.supportedAnnotations;
    }

    public Collection<P> getPlugins() {
        return this.pluginMap.values();
    }

    public void add(M metaModel) {
        ((MetaModel)metaModel).processingContext = this.processingContext;
        ((MetaModel)metaModel).forward = true;
        ((MetaModel)metaModel).context = this;
        ((MetaModel)metaModel).init(this.processingContext);
        for (MetaModelPlugin plugin : this.pluginMap.values()) {
            plugin.init(metaModel);
        }
        this.metaModels.add(metaModel);
    }

    public final void postActivate(ProcessingContext processingContext) throws NullPointerException {
        this.processingContext = processingContext;
        for (MetaModel metaModel : this.metaModels) {
            metaModel.processingContext = processingContext;
            for (MetaModelPlugin plugin : this.pluginMap.values()) {
                plugin.postActivate(metaModel);
            }
        }
    }

    public void processAnnotationChange(AnnotationChange change) {
        if (change.getAdded() == null) {
            this.knownAnnotations.remove(change.getKey());
        } else {
            this.knownAnnotations.put(change.getKey(), change.getAdded());
        }
        for (MetaModel metaModel : this.metaModels) {
            if (metaModel.forward) {
                metaModel.forward = false;
                for (Map.Entry entry : this.knownAnnotations.entrySet()) {
                    change = new AnnotationChange((AnnotationKey)entry.getKey(), null, (AnnotationState)entry.getValue());
                    for (MetaModelPlugin plugin : this.pluginMap.values()) {
                        HashSet<Name> supportedAnnotations = this.supportedAnnotationsMap.get(plugin);
                        if (!supportedAnnotations.contains(change.key.type)) continue;
                        plugin.processAnnotationChange(metaModel, change);
                    }
                }
                continue;
            }
            for (MetaModelPlugin metaModelPlugin : this.pluginMap.values()) {
                HashSet<Name> supportedAnnotations = this.supportedAnnotationsMap.get(metaModelPlugin);
                if (!supportedAnnotations.contains(change.key.type)) continue;
                metaModelPlugin.processAnnotationChange(metaModel, change);
            }
        }
    }

    public void processAnnotationChanges(Iterable<AnnotationChange> changes) {
        for (AnnotationChange change : changes) {
            this.processAnnotationChange(change);
        }
    }

    void processAnnotations(Iterable<Map.Entry<AnnotationKey, AnnotationState>> annotations) {
        ArrayList<AnnotationChange> delta = new ArrayList<AnnotationChange>();
        for (Map.Entry<AnnotationKey, AnnotationState> entry : this.knownAnnotations.entrySet()) {
            AnnotationKey key = entry.getKey();
            Object element = this.processingContext.get(key.element);
            if (element == null) {
                delta.add(new AnnotationChange(key, entry.getValue(), null));
                this.processingContext.log(Level.FINER, "Annotation removed " + key);
                continue;
            }
            AnnotationMirror found = null;
            for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
                Name f = Name.parse(((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName().toString());
                if (!key.getType().equals(f)) continue;
                found = annotationMirror;
                break;
            }
            if (found != null) continue;
            delta.add(new AnnotationChange(key, entry.getValue(), null));
            this.processingContext.log(Level.FINER, "Annotation removed " + key);
        }
        for (Map.Entry<AnnotationKey, AnnotationState> annotation : annotations) {
            AnnotationState knownAnnotation = this.knownAnnotations.get(annotation.getKey());
            if (knownAnnotation != null) {
                this.processingContext.log(Level.FINER, "Annotation updated " + annotation.getKey());
            } else {
                this.processingContext.log(Level.FINER, "Annotation added " + annotation.getKey());
            }
            delta.add(new AnnotationChange(annotation.getKey(), knownAnnotation, annotation.getValue()));
        }
        this.processAnnotationChanges(delta);
    }

    public Iterable<? extends Completion> getCompletions(AnnotationKey annotationKey, AnnotationState annotationState, String member, String userText) {
        Iterable<Completion> completions = null;
        for (MetaModel metaModel : this.metaModels) {
            MetaModelPlugin plugin;
            HashSet<Name> supportedAnnotations;
            Iterator<P> i$ = this.pluginMap.values().iterator();
            while (i$.hasNext() && (!(supportedAnnotations = this.supportedAnnotationsMap.get(plugin = (MetaModelPlugin)i$.next())).contains(annotationKey.type) || (completions = plugin.getCompletions(metaModel, annotationKey, annotationState, member, userText)) == null)) {
            }
        }
        return completions;
    }

    public void postProcessAnnotations() throws ProcessingException {
        for (MetaModel metaModel : this.metaModels) {
            for (MetaModelPlugin plugin : this.pluginMap.values()) {
                plugin.postProcessAnnotations(metaModel);
            }
        }
    }

    public void processEvents() {
        for (MetaModel metaModel : this.metaModels) {
            for (MetaModelPlugin plugin : this.pluginMap.values()) {
                plugin.processEvents(metaModel, new EventQueue(metaModel.dispatch));
            }
            metaModel.dispatch.clear();
        }
    }

    public void postProcessEvents() {
        for (MetaModel metaModel : this.metaModels) {
            for (MetaModelPlugin plugin : this.pluginMap.values()) {
                plugin.postProcessEvents(metaModel);
            }
        }
    }

    public void prePassivate() {
        for (MetaModel metaModel : this.metaModels) {
            for (MetaModelPlugin plugin : this.pluginMap.values()) {
                plugin.prePassivate(metaModel);
            }
            metaModel.processingContext = null;
        }
        this.processingContext = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(M metaModel) {
        try {
            ((MetaModel)metaModel).processingContext = this.processingContext;
            this.metaModels.remove(metaModel);
            for (MetaModelPlugin plugin : this.pluginMap.values()) {
                plugin.destroy(metaModel);
            }
        }
        finally {
            ((MetaModel)metaModel).processingContext = null;
        }
    }
}

