/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.plugin.asset;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.StandardLocation;
import juzu.asset.AssetLocation;
import juzu.impl.common.JSON;
import juzu.impl.common.Name;
import juzu.impl.common.Path;
import juzu.impl.common.Tools;
import juzu.impl.compiler.ProcessingContext;
import juzu.impl.metamodel.AnnotationKey;
import juzu.impl.metamodel.AnnotationState;
import juzu.impl.plugin.application.metamodel.ApplicationMetaModel;
import juzu.impl.plugin.application.metamodel.ApplicationMetaModelPlugin;
import juzu.impl.plugin.asset.AssetsMetaModel;
import juzu.plugin.asset.Assets;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssetMetaModelPlugin
extends ApplicationMetaModelPlugin {
    private static final String[] KINDS = new String[]{"value"};

    public AssetMetaModelPlugin() {
        super("asset");
    }

    @Override
    public Set<Class<? extends Annotation>> init(ProcessingContext env) {
        return Collections.singleton(Assets.class);
    }

    @Override
    public void init(ApplicationMetaModel metaModel) {
        metaModel.addChild(AssetsMetaModel.KEY, new AssetsMetaModel());
    }

    @Override
    public void processAnnotationAdded(ApplicationMetaModel metaModel, AnnotationKey key, AnnotationState added) {
        metaModel.getChild(AssetsMetaModel.KEY).annotations.put(metaModel.getHandle(), added);
    }

    @Override
    public void processAnnotationRemoved(ApplicationMetaModel metaModel, AnnotationKey key, AnnotationState removed) {
        metaModel.getChild(AssetsMetaModel.KEY).annotations.remove(metaModel.getHandle());
    }

    private List<JSON> build(List<Map<String, Object>> scripts) {
        ArrayList<JSON> foo = new ArrayList<JSON>();
        if (scripts != null) {
            for (Map<String, Object> script : scripts) {
                JSON bar = new JSON();
                for (Map.Entry<String, Object> entry : script.entrySet()) {
                    bar.set(entry.getKey(), entry.getValue());
                }
                foo.add(bar);
            }
        }
        return foo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prePassivate(ApplicationMetaModel metaModel) {
        AnnotationState annotation;
        ProcessingContext context = metaModel.getProcessingContext();
        if (!context.isCopyFromSourcesExternallyManaged() && (annotation = metaModel.getChild(AssetsMetaModel.KEY).annotations.get(metaModel.getHandle())) != null) {
            String location = (String)annotation.get("location");
            boolean classpath = location == null || AssetLocation.APPLICATION.equals((Object)AssetLocation.safeValueOf(location));
            for (String kind : KINDS) {
                List scripts = (List)annotation.get(kind);
                if (scripts == null) continue;
                for (AnnotationState script : scripts) {
                    location = (String)script.get("location");
                    if ((location != null || !classpath) && !AssetLocation.APPLICATION.equals((Object)AssetLocation.safeValueOf(location))) continue;
                    List values = (List)script.get("value");
                    for (String value : values) {
                        Path path = Path.parse(value);
                        if (!path.isRelative()) continue;
                        context.info("Found classpath asset to copy " + value);
                        Name qn = metaModel.getHandle().getPackageName().append("assets");
                        Path.Absolute absolute = qn.resolve(path);
                        FileObject src = context.resolveResourceFromSourcePath(metaModel.getHandle(), absolute);
                        if (src != null) {
                            OutputStream out;
                            InputStream in;
                            block10: {
                                URI srcURI = src.toUri();
                                context.info("Found asset " + absolute + " on source path " + srcURI);
                                in = null;
                                out = null;
                                try {
                                    FileObject dst = context.getResource((JavaFileManager.Location)StandardLocation.CLASS_OUTPUT, absolute);
                                    if (dst == null || dst.getLastModified() < src.getLastModified()) {
                                        in = src.openInputStream();
                                        dst = context.createResource((JavaFileManager.Location)StandardLocation.CLASS_OUTPUT, absolute, context.get(metaModel.getHandle()));
                                        context.info("Copying asset from source path " + srcURI + " to class output " + dst.toUri());
                                        out = dst.openOutputStream();
                                        Tools.copy(in, out);
                                        break block10;
                                    }
                                    context.info("Found up to date related asset in class output for " + srcURI);
                                }
                                catch (IOException e) {
                                    try {
                                        context.info("Could not copy asset " + path + " ", e);
                                    }
                                    catch (Throwable throwable) {
                                        Tools.safeClose(in);
                                        Tools.safeClose(out);
                                        throw throwable;
                                    }
                                    Tools.safeClose(in);
                                    Tools.safeClose(out);
                                    continue;
                                }
                            }
                            Tools.safeClose(in);
                            Tools.safeClose(out);
                            continue;
                        }
                        context.info("Could not find asset " + absolute + " on source path");
                    }
                }
            }
        }
    }

    @Override
    public JSON getDescriptor(ApplicationMetaModel application) {
        AnnotationState annotation = application.getChild(AssetsMetaModel.KEY).annotations.get(application.getHandle());
        if (annotation != null) {
            JSON json = new JSON();
            List<JSON> assets = this.build((List)annotation.get("value"));
            json.set("assets", assets);
            json.set("package", "assets");
            json.set("location", annotation.get("location"));
            return json;
        }
        return null;
    }
}

