/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.bridge.spi.servlet;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import juzu.impl.bridge.BridgeContext;
import juzu.impl.common.JSON;
import juzu.impl.common.JUL;
import juzu.impl.common.Logger;
import juzu.impl.common.Tools;
import juzu.impl.fs.spi.ReadFileSystem;
import juzu.impl.fs.spi.disk.DiskFileSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBridgeContext
implements BridgeContext {
    public static final String SOURCE_PATH = "juzu.src_path";
    ReadFileSystem<?> sourcePath;

    @Override
    public final ReadFileSystem<?> getSourcePath() {
        if (this.sourcePath == null) {
            String sourcePathParam = this.getInitParameter(SOURCE_PATH);
            if (sourcePathParam != null) {
                this.sourcePath = new DiskFileSystem(new File(sourcePathParam));
            } else {
                try {
                    File sourcePathRoot;
                    String configValue;
                    JSON config;
                    String sourcePathValue;
                    URL configURL = this.getClassLoader().getResource("juzu/config.json");
                    if (configURL != null && (sourcePathValue = (config = (JSON)JSON.parse(configValue = Tools.read(configURL))).getString("sourcepath")) != null && (sourcePathRoot = new File(sourcePathValue)).isDirectory() && sourcePathRoot.exists()) {
                        this.sourcePath = new DiskFileSystem(sourcePathRoot);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return this.sourcePath;
    }

    @Override
    public final Logger getLogger(String name) {
        return JUL.getLogger(name);
    }
}

